% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/keyword_merge.R
\name{keyword_merge}
\alias{keyword_merge}
\title{Merge keywords that supposed to have same meanings}
\usage{
keyword_merge(dt, id = "id", keyword = "keyword", reduce_form = "lemma")
}
\arguments{
\item{dt}{A data.frame containing at least two columns with document ID and keyword.}

\item{id}{Quoted characters specifying the column name of document ID.Default uses "id".}

\item{keyword}{Quoted characters specifying the column name of keyword.Default uses "keyword".}

\item{reduce_form}{Should the merge terms have the same stem("stem") or lemma("lemma")?
Default uses "lemma".}
}
\value{
A tbl, namely a tidy table with document ID and merged keyword.
}
\description{
Merge keywords that have common stem or lemma, and return the majority form of the word. This function
recieves a tidy table (data.frame) with document ID and keyword waiting to be merged.
}
\details{
While \code{keyword_clean} has provided a robust way to lemmatize the keywords, the returned token
might not be the most common way to use.This function first gets the stem or lemma of
every keyword using \code{\link{stem_strings}} or \code{\link{lemmatize_strings}} from \pkg{textstem} package,
then find the most frequent form (if more than 1,randomly select one)
for each stem or lemma. Last, every keyword
would be replaced by the most frequent keyword which share the same stem or lemma with it.
}
\examples{
library(akc)

\donttest{
bibli_data_table \%>\%
  keyword_clean(lemmatize = FALSE) \%>\%
  keyword_merge(reduce_form = "stem")

bibli_data_table \%>\%
  keyword_clean(lemmatize = FALSE) \%>\%
  keyword_merge(reduce_form = "lemma")
}

}
\seealso{
\code{\link[textstem]{stem_strings}}, \code{\link[textstem]{lemmatize_strings}}
}
