% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rates.R
\name{rates}
\alias{rates}
\title{Conversion of counts to rates}
\usage{
rates(traj, denomin, id_field, multiplier)
}
\arguments{
\item{traj}{[matrix (numeric)] longitudinal (e.g.
observed count) data (\code{m x n}). Each row represents an
individual trajectory (of observations). The columns show the
observations at consecutive time steps.}

\item{denomin}{[matrix (numeric)] longitudinal (denominator)
data of the same column as `traj` (\code{n}).}

\item{id_field}{[numeric or character] Default is \code{TRUE}.
The first column of both the `traj` and the `denomin` object
must be the unique (\code{id}) field. If \code{FALSE}, the function
will terminate. The assumption is that columns of both the
\code{traj} and \code{denominat} corresponds. That is, column2,
column3, ... represent time points 2, 3, ..., respectively, in
each object.}

\item{multiplier}{[numeric] A quantify by which to the ratio
\code{traj/denomin} is expressed. Default is \code{100}.}
}
\value{
An object which comprised of four output variables, namely:
(i) `$common_ids` - individual ids present in both
`traj` (trajectory data) and `denomin` (denominator data);
(ii) `$ids_unique_to_traj_data` - individual ids unique to
trajectory data (i.e. not present in the denominator data);
(iii) `$ids_unique_to_denom_data` - individual ids unique
to denominator data (i.e. not present in the trajectory data);
(iv) `` - a dataframe of rates estimates. Note: only the individual
ids in `$rates_estimates` are used in the `rates` estimation.
}
\description{
Calculates rates from 'observed' count and a
denominator data
}
\examples{

traj2 <- data_imputation(traj, id_field = TRUE, method = 2,
replace_with = 1, fill_zeros = FALSE)

pop <- popl #read denominator data

pop2 <- as.data.frame(matrix(0, nrow(popl), ncol(traj)))

colnames(pop2) <- names(traj2$CompleteData)

pop2[,1] <- as.vector(as.character(pop[,1]))

pop2[,4] <- as.vector(as.character(pop[,2]))

pop2[,8] <- as.vector(as.character(pop[,3]))

list_ <- c(2, 3, 5, 6, 7, 9, 10) #vector of missing years

#fill the missing fields with 'NA'
for(u_ in seq_len(length(list_))){
    pop2[,list_[u_]] <- "NA"
}

#estimate missing fields
pop_imp_result <- data_imputation(pop2, id_field = TRUE, method = 2,
replace_with = 1, fill_zeros = FALSE)

#calculate rates i.e. crimes per 200 population
crime_rates <- rates(traj2$CompleteData, denomin=pop_imp_result$CompleteData,
id_field=TRUE, multiplier = 200)

}
