% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{Silverman}
\alias{Silverman}
\alias{Silverman2}
\alias{bw}
\title{Kernel density bandwidth estimators.}
\usage{
Silverman(x)

Silverman2(x)

bw(x, type)
}
\arguments{
\item{x}{A vector of data points.}

\item{type}{One of the following options:
\itemize{
\item -1: Silverman's rule of thumb.
\item -2: Silverman's adapted rule of thumb.
\item >0: The real number is returned without any calculations.
}}
}
\value{
Silverman: Bandwidth estimator based on Silverman's rule of thumb.

Silverman2: Bandwidth estimator based on Silverman's adapted rule of thumb.

bw: Bandwidth estimator based on the selected method.
}
\description{
Calculate the bandwidth estimator using various methods.
}
\examples{
set.seed(1)
x <- rnorm(100)
Silverman(x)

Silverman2(x)

bw(x, -1)
bw(x, -2)
bw(x, 0.5)

}
