% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/batTest.R
\name{bhatt.test}
\alias{bhatt.test}
\title{Bhattacharryya test for comparing  two samples.}
\usage{
bhatt.test(y, x, k)
}
\arguments{
\item{y, x}{Samples to be compared.}

\item{k}{Number of proportions.}
}
\value{
bat.test: A list with the following components:
\itemize{
\item df=2*k: where k is the number of proportions used.
\item y.prop, x.prop: Vectors of proportions.
\item D2: Measure of divergence between samples.
\item test.stat: The test statistic for the Bhattacharrayya test.
\item p.value: The p-value of the test.
}
}
\description{
Use the multinomial distribution to test the hypothesis that two samples come from the same distribution.
}
\details{
It is assumed that the two samples come from the same kernel density distribution.  The support of the KDE of the first sample is divided into \eqn{k} equally spaced quantiles, and then compared to the corresponding proportions of the second.
}
\examples{
y <- rnorm(1000)
x <- rnorm(1000)
bhatt.test(y,x,10)

}
