% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kappa4nlsBoot.R
\name{kappa4nlsBoot}
\alias{kappa4nlsBoot}
\alias{kappa4nlsBoot.default}
\alias{print.kappa4nlsBoot}
\alias{summary.kappa4nlsBoot}
\alias{print.summary.kappa4nlsBoot}
\alias{kappa4nlsBoot.formula}
\alias{predict.kappa4nlsBoot}
\title{Sigmoidal curve fitting.}
\usage{
kappa4nlsBoot(formula, data = list(), xin, lower, upper, tol, maxiter,
  bootstraps, bootName, ...)

\method{kappa4nlsBoot}{default}(formula, data = list(), xin, lower = c(0,
  -5, -5), upper = c(10, 1, 1), tol = 1e-15, maxiter = 50000, bootstraps,
  bootName, ...)

\method{print}{kappa4nlsBoot}(x, ...)

\method{summary}{kappa4nlsBoot}(object, ...)

\method{print}{summary.kappa4nlsBoot}(x, ...)

\method{kappa4nlsBoot}{formula}(formula, data = list(), xin, lower, upper,
  tol, maxiter, bootstraps, bootName, ...)

\method{predict}{kappa4nlsBoot}(object, newdata = NULL, ...)
}
\arguments{
\item{formula}{An LHS ~ RHS formula, specifying the linear model to be estimated.}

\item{data}{A data.frame which contains the variables in \code{formula}.}

\item{xin}{Numeric vector of length 3 containing initial values, for \eqn{\sigma}, \eqn{h}, and \eqn{k}.}

\item{lower}{A vector of lower constraints for the parameters to be estimated; defaults to c(0, -5, -5).}

\item{upper}{A vector of upper constraints for the parameters to be estimated; defaults to c(10, 1, 1).}

\item{tol}{Error tolerance level; defaults to 1e-15.}

\item{maxiter}{The maximum number of iterations allowed; defaults to 50000.}

\item{bootstraps}{An integer giving the number of bootstrap samples.}

\item{bootName}{The name of the .rds file to store the kappa4nlsBoot object.  May include a path.}

\item{...}{Arguments to be passed on to the differential evolution function \code{\link{JDEoptim}}.}

\item{x}{A kappa4nlsBoot object.}

\item{object}{A kappa4nlsBoot object.}

\item{newdata}{The data on which the estimated model is to be fitted.}
}
\value{
A generic S3 object with class kappa4nlsBoot.

kappa4nlsBoot.default: A list object (saved using \code{saveRDS} in the specified location) with the following components:
\itemize{
\item intercept: Did the model contain an intercept TRUE/FALSE?
\item coefficients: A vector of estimated coefficients.
\item bcoefficients: A vector of bootstrap coefficients, resulting from bootstrap estimation.
\item se: The standard errors for the estimates resulting from bootstrap estimation.
\item error: The value of the objective function.
\item errorList: A vector of values of the objective function for each bootstrap sample.
\item fitted.values: A vector of estimated values.
\item residuals: The residuals resulting from the fitted model.
\item call: The call to the function.
\item time: Min, mean and max time incurred by the computation, as obtained from \code{\link{comm.timer}}.
}

summary.kappa4nlsBoot: A list of class summary.kappa4nlsBoot with the following components:
\itemize{
\item call: Original call to the \code{kappa4nlsBoot} function.
\item coefficients: A matrix with estimates, estimated errors, and 95\% parameter confidence intervals (based on the inverse empirical distribution function).
\item r.squared: The \eqn{r^{2}} coefficient.
\item sigma: The residual standard error.
\item error: Value of the objective function.
\item time: Min, mean and max time incurred by the computation, as obtained from \code{\link{comm.timer}}.
\item residSum: Summary statistics for the distribution of the residuals.
\item errorSum: Summary statistics for the distribution of the value of the objective function.
}

print.summary.kappa4nlsBoot: The object passed to the function is returned invisibly.

predict.kappa4nlsBoot: A vector of predicted values resulting from the estimated model.
}
\description{
Bootstrap estimates, along with standard  errors and confidence intervals, of a nonlinear model, resulting from  nonlinear least squares fitting of the four-parameter kappa sigmoidal function.
}
\section{Methods (by class)}{
\itemize{
\item \code{default}: default method for kappa4nlsBoot.

\item \code{kappa4nlsBoot}: print method for kappa4nlsBoot.

\item \code{kappa4nlsBoot}: summary method for kappa4nlsBoot.

\item \code{summary.kappa4nlsBoot}: print method for summary.kappa4nlsBoot.

\item \code{formula}: formula method for kappa4nlsBoot.

\item \code{kappa4nlsBoot}: predict method for kappa4nlsBoot.
}}

