% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Sequence.R
\name{testSeqEqual}
\alias{testSeqEqual}
\title{Test DNA sequences for equality.}
\usage{
testSeqEqual(seq1, seq2, ignore = c("N", "-", ".", "?"))
}
\arguments{
\item{seq1}{character string containing a DNA sequence.}

\item{seq2}{character string containing a DNA sequence.}

\item{ignore}{vector of characters to ignore when testing for equality.}
}
\value{
Returns \code{TRUE} if sequences are equal and \code{FALSE} if they are not.
          Sequences of unequal length will always return \code{FALSE} regardless of
          their character values.
}
\description{
\code{testSeqEqual} checks if two DNA sequences are identical.
}
\examples{
# Ignore gaps
testSeqEqual("ATG-C", "AT--C")
testSeqEqual("ATGGC", "ATGGN")
testSeqEqual("AT--T", "ATGGC")

# Ignore only Ns
testSeqEqual("ATG-C", "AT--C", ignore="N")
testSeqEqual("ATGGC", "ATGGN", ignore="N")
testSeqEqual("AT--T", "ATGGC", ignore="N")

}
\seealso{
Used by \code{\link{collapseDuplicates}}.
}

