Alakazam
-------------------------------------------------------------------------------

Alakazam is part of the [Immcantation](http://immcantation.readthedocs.io) 
analysis framework for Adaptive Immune Receptor Repertoire sequencing 
(AIRR-seq) and provides a set of tools to investigate lymphocyte 
receptor clonal lineages, diversity, gene usage, and other repertoire level 
properties, with a focus on high-throughput immunoglobulin (Ig) sequencing.

Alakazam serves five main purposes:

1. Providing core functionality for other R packages in the Immcantation 
   framework. This includes common tasks such as file I/O, basic DNA sequence 
   manipulation, and interacting with V(D)J segment and gene annotations.
2. Providing an R interface for interacting with the output of the 
   [pRESTO](http://presto.readthedocs.io) and 
   [Change-O](http://changeo.readthedocs.io) tool suites.
3. Performing lineage reconstruction on clonal populations of Ig sequences 
   and analyzing the topology of the resultant lineage trees. 
4. Performing clonal abundance and diversity analysis on lymphocyte 
   repertoires.
5. Performing physicochemical property analyses of lymphocyte receptor 
   sequences.


Contact
-------------------------------------------------------------------------------

For help and questions please contact the [Immcantation Group](mailto:immcantation@googlegroups.com)
or use the [issue tracker](https://bitbucket.org/kleinstein/alakazam/issues?status=new&status=open).