% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AminoAcids.R
\name{countPatterns}
\alias{countPatterns}
\title{Count sequence patterns}
\usage{
countPatterns(seq, patterns, nt = FALSE, trim = FALSE, label = "region")
}
\arguments{
\item{seq}{character vector of either DNA or amino acid sequences.}

\item{patterns}{list of sequence patterns to count in each sequence. If the 
list is named, then names will be assigned as the column names of 
output data.frame.}

\item{nt}{if \code{TRUE} then \code{seq} are DNA sequences and and will be 
translated before performing the pattern search.}

\item{trim}{if \code{TRUE} remove the first and last codon or amino acid from 
each sequence before the pattern search. If \code{FALSE} do
not modify the input sequences.}

\item{label}{string defining a label to add as a prefix to the output 
column names.}
}
\value{
A data.frame containing the fraction of times each sequence pattern was 
         found.
}
\description{
\code{countPatterns} counts the fraction of times a set of character patterns occur 
in a set of sequences.
}
\examples{
seq <- c("TGTCAACAGGCTAACAGTTTCCGGACGTTC",
         "TGTCAGCAATATTATATTGCTCCCTTCACTTTC",
         "TGTCAAAAGTATAACAGTGCCCCCTGGACGTTC")
patterns <- c("A", "V", "[LI]")
names(patterns) <- c("arg", "val", "iso_leu")
countPatterns(seq, patterns, nt=TRUE, trim=TRUE, label="cdr3")
            
}
