% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/alm_sources.R
\name{alm_sources}
\alias{alm_sources}
\title{Retrieve PLoS article-level metrics (ALM) by source.}
\usage{
alm_sources(source_id = "crossref", info = "totals", key = NULL,
  total_details = FALSE, sum_metrics = NULL, limit = 50, page = 1,
  url = "http://alm.plos.org/api/v5/articles", ...)
}
\arguments{
\item{source_id}{(character) Name of source to get ALM information for. One source only.
You can get multiple sources via a for loop or lapply-type call.}

\item{info}{One of totals, summary, or detail (default totals + sum_metrics data in a list).
Not specifying anything (the default) returns data.frame of totals across
  data providers. (character)}

\item{key}{(character) Your API key, either enter, or loads from .Rprofile. Only required for
PKP source, not the others.}

\item{total_details}{If FALSE (the default) the standard totals data.frame is
returned; if TRUE, the totals data is in a wide format with more details
about the paper, including publication date, title, etc. If you set this
to TRUE, the output should no longer with with \code{\link{alm_plot}}.}

\item{sum_metrics}{Just like the output you get from setting info='totals', you can
get summary metrics by day (sum_metrics='day'), month (sum_metrics='month'),
or year (sum_metrics='year').}

\item{limit}{(integer) Number from 1 to infinity. This doubles as the rows parameter, which is
what's called internally to the API service. The max results per page is 50, so if you use a
value > 50, then we essentially loop through to get all the results you want.}

\item{page}{(integer) Number from 1 to infinity.}

\item{url}{API endpoint, defaults to http://alm.plos.org/api/v3/articles (character)}

\item{...}{optional additional curl options (debugging tools mostly)}
}
\description{
See details for more information.
}
\examples{
\dontrun{
alm_sources()
alm_sources(source_id='mendeley')
alm_sources(source_id='scopus', info='summary')
lapply(c('mendeley','twitter'), alm_sources, limit = 2)
alm_sources(source_id='mendeley', limit=2)
alm_sources(source_id='mendeley', limit=2, page=2)
alm_sources(source_id='mendeley', limit=200)

alm_sources(source_id='mendeley', info='summary')
}
}
\references{
See a tutorial/vignette for alm at
\url{http://ropensci.org/tutorials/alm_tutorial.html}
}

