% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vega-data.R
\name{import_vega_data}
\alias{import_vega_data}
\title{Import Vega datasets}
\usage{
import_vega_data()
}
\value{
An S3 object of class \code{vega_datasets.core.DataLoader}
}
\description{
Lets you access Vega datasets.
}
\details{
Returns the \code{data} object in the Python package
\href{https://github.com/altair-viz/vega_datasets}{vega-datasets}.
In the documentation for this package, the convention is to
assign this object to the name \code{vega_data}.
}
\examples{
if (interactive()) {
  vega_data <- import_vega_data()

  # To list available datasets
  print(vega_data$list_datasets())

  # When accessing a dataset, substitute any "-" in the name with a "_"
  print(head(vega_data$sf_temps()))

  # Metadata are available for each dataset:
  print(vega_data$anscombe$references)
  print(vega_data$anscombe$description)
  print(vega_data$anscombe$url)

  # For local datasets, local path is available
  print(vega_data$sf_temps$filepath)
}
}
\seealso{
\href{https://github.com/altair-viz/vega_datasets}{Vega datasets documentation}
}
