% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scores.compare.R
\name{scores.compare}
\alias{scores.compare}
\title{Compares scores from two model runs}
\usage{
scores.compare(mod01.path, mod02.path, mod01.id, mod02.id,
  score.weights = c(1, 2, 1, 1, 1), outputDir = FALSE)
}
\arguments{
\item{mod01.path}{A string that gives the path where the output from \link{scores.tables} is stored (model 1)}

\item{mod02.path}{A string that gives the path where the output from \link{scores.tables} is stored (model 2)}

\item{mod01.id}{A string that gives the name of a model, e.g. 'CanESM2'}

\item{mod02.id}{A string that gives the name of a model, e.g. 'CanESM5'}

\item{score.weights}{R object that gives the weights of each score (\eqn{S_{bias}}, \eqn{S_{rmse}}, \eqn{S_{phase}}, \eqn{S_{iav}}, \eqn{S_{dist}})
that are used for computing the overall score, e.g. c(1,2,1,1,1)}

\item{outputDir}{A string that gives the output directory, e.g. '/home/project/study'. The output will only be written if the user specifies an output directory.}
}
\value{
A figure in PDF format that shows the (a) skill score and (b) skill
score difference when compared against a different model run. White numbers
indicate that score differences are not statistically significant at the
5 percent level using the two-sided Wilcox significance test.
}
\description{
This function compares scores from two different model runs.
}
\examples{

library(amber)
library(raster)

mod01.path <- system.file('extdata/model01', package = 'amber')
mod02.path <- system.file('extdata/model02', package = 'amber')
mod01.id <- 'Model01'
mod02.id <- 'Model02'
score.weights <- c(1,2,1,1,1)
scores.compare(mod01.path, mod02.path, mod01.id, mod02.id,  score.weights)

}
