% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/intFun.R
\name{intFun.grid.na}
\alias{intFun.grid.na}
\title{Replace NA with zero in raster object}
\usage{
intFun.grid.na(x)
}
\arguments{
\item{x}{A raster object}
}
\value{
A raster object where all NA's have been replaced with zero
}
\description{
This function sets all NA's in a raster object to zero.
}
\examples{

library(raster)
# create a raster object with NA
data <- c(runif(99,-10,10),NA)
data <- matrix(data, ncol=10)
data <- raster::raster(data)
# replace NA with zero in raster object
data <- intFun.grid.na(data)
plot(data); text(data)

}
\keyword{internal}
