% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/amf_download_base.R
\name{amf_download_base}
\alias{amf_download_base}
\title{Download AmeriFlux BASE data product}
\usage{
amf_download_base(
  user_id,
  user_email,
  site_id,
  data_product = "BASE-BADM",
  data_policy,
  agree_policy,
  intended_use,
  intended_use_text,
  out_dir = tempdir(),
  verbose = TRUE
)
}
\arguments{
\item{user_id}{AmeriFlux account username (character)}

\item{user_email}{AmeriFlux account user email (character)}

\item{site_id}{A scalar or vector of character specifying the AmeriFlux
Site ID (CC-Sss)}

\item{data_product}{AmeriFlux data product. Currently, only "BASE-BADM" is
supported and used as default. (character)}

\item{data_policy}{"CCBY4.0" or "LEGACY" (character). AmeriFlux data
 are shared under two tiers of licenses as chosen by site's  PI. See
\url{https://ameriflux.lbl.gov/data/data-policy/#data-use} for data use
guidelines under each license. Note: Data use policy
selected affects which sites’ data are available for download.}

\item{agree_policy}{Acknowledge you read and agree to the AmeriFlux
Data use policy (TRUE/FALSE)}

\item{intended_use}{The intended use category. Currently, it needs to be one
of the followings:
\itemize{
  \item "synthesis" (i.e., Multi-site synthesis)
  \item "model" (i.e., Land model/Earth system model)
  \item "remote_sensing" (i.e., Remote sensing research)
  \item "other_research" (i.e., Other research)
 "\item "education" (i.e., Education (Teacher or Student))
  \item "other"
}}

\item{intended_use_text}{Enter a brief description of intended use. This
will be recorded in the download log and emailed to site's PI (character).}

\item{out_dir}{Output directory for downloaded data, default tempdir()}

\item{verbose}{Show feedback on download progress (TRUE/FALSE)}
}
\value{
A vector of download file names on the local drive
}
\description{
This function downloads AmeriFlux BASE and BADM data files.
 Note: Access to AmeriFlux data requires creating an AmeriFlux account
 first. Register an account through the link
  \url{https://ameriflux-data.lbl.gov/Pages/RequestAccount.aspx}.

For details about BASE and BADM data files, see AmeriFlux web pages
 \url{https://ameriflux.lbl.gov/data/data-processing-pipelines/base-publish/}
and \url{https://ameriflux.lbl.gov/data/aboutdata/badm-data-product/}.
}
\examples{

\dontrun{
## Download a single site, under CCBY4.0 policy
amf_download_base(user_id = "test",
 user_email = "test _at_ mail.com",
 site_id = "US-CRT",
 data_product = "BASE-BADM",
 data_policy = "CCBY4.0",
 agree_policy = TRUE,
 intended_use = "other",
 intended_use_text = "testing download",
 out_dir = tempdir())

## Download several sites, under LEGACY data policy
#  When finished, return a list of downloaded files
#  in your local drive.
file.ls <- amf_download_base(user_id = "test",
 user_email = "test _at_ mail.com",
 site_id = c("US-CRT", "US-WPT", "US-Oho"),
 data_product = "BASE-BADM",
 data_policy = "LEGACY",
 agree_policy = TRUE,
 intended_use = "other",
 intended_use_text = "testing download",
 out_dir = tempdir())
}

}
