% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/amf_read_bif.R
\name{amf_read_bif}
\alias{amf_read_bif}
\title{Read AmeriFlux BADM data product}
\usage{
amf_read_bif(file)
}
\arguments{
\item{file}{A BADM data file}
}
\value{
A data frame containing the following 5 columns.
See AmeriFlux website
 \url{https://ameriflux.lbl.gov/data/aboutdata/badm-data-product/} for
 details.
\itemize{
  \item SITE_ID - Six character site identifier (CC-Sss)
  \item GROUP_ID - A unique identifier for data belonging to the same
  instance of a reported variable group
  \item VARIABLE_GROUP - A set of variables that are reported together
  \item VARIABLE - The variable name
  \item DATAVALUE - The reported value of a variable
}
}
\description{
This function read in the BADM data file formatted in BADM
Interchange Format (BIF).
}
\examples{
# read the BADM BIF file, using an example data file
bif <- amf_read_bif(file = system.file("extdata",
                                       "AMF_AA-Flx_BIF_CCBY4_20201218.xlsx",
                                        package = "amerifluxr"))
}
