% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/track_transform_crs.R
\name{transform_coords}
\alias{transform_coords}
\alias{transform_coords.track_xy}
\alias{transform_crs}
\title{Transform CRS}
\usage{
transform_coords(x, ...)

\method{transform_coords}{track_xy}(x, crs_to, crs_from, ...)

transform_crs(x, ...)
}
\arguments{
\item{x}{\code{[track_xy, track_xyt]} \cr A track created with \code{mk_track} or \code{track}.}

\item{...}{Further arguments, none implemented.}

\item{crs_to}{\code{[sp::CRS(1)]} \cr Coordinate reference system the data should be transformed to, see \code{sp::CRS}.}

\item{crs_from}{\code{[sp::CRS(1)]} \cr Coordinate reference system the data are currently in, see \code{sp::CRS}. If \code{crs_from} is missing, the \code{crs}-attribute of the track is used.}
}
\description{
Transforms the CRS for a track.
}
\examples{
data(deer)
get_crs(deer)

# project to geographical coordinates (note the CRS is taken automatically from the object deer).
d1 <- transform_coords(deer, sp::CRS("+init=epsg:4326"))
}
\seealso{
sp::spTransform
}
