% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/unit_converter.R
\name{convert_toMolar}
\alias{convert_toMolar}
\title{Convert a unit to molar}
\usage{
convert_toMolar(val, unit)
}
\arguments{
\item{val}{numeric value of the analyte concentration}

\item{unit}{character string indicating the unit from which, the analyte concentration will be converted into molar.}
}
\value{
The value of analyte concentration in molar
}
\description{
convert the value into molar.
}
\details{
supported units are: millimolar, micromolar, nanomolar and picomolar. The name of the unit could be written, or its
abbreviation such as: nanomolar (nm), micromolar (mim), picomolar (pm), or millimolar (mm). The unite in either form is case insensitive.
}
\examples{
convert_toMolar(120, "nanomolar")
convert_toMolar(120, "nm")
convert_toMolar(120, "millimolar")
convert_toMolar(120, "mm")
convert_toMolar(120, "micromolar")
convert_toMolar(120, "mim")
convert_toMolar(120, "picomolar")
convert_toMolar(120, "pm")

}
