% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/droplet-actions.R
\name{droplet_create}
\alias{droplet_create}
\title{Create a new droplet.}
\usage{
droplet_create(name = random_name(), size = getOption("do_size", "512mb"),
  image = getOption("do_image", "ubuntu-14-04-x64"),
  region = getOption("do_region", "sfo1"),
  ssh_keys = getOption("do_ssh_keys", NULL),
  backups = getOption("do_backups", NULL), ipv6 = getOption("do_ipv6",
  NULL), private_networking = getOption("do_private_networking", NULL),
  user_data = NULL, cloud_config = NULL, wait = TRUE, ...)
}
\arguments{
\item{name}{(character) Name of the droplet. Default: picks a random name
from \code{\link{words}} if none supplied.}

\item{size}{(character) Size slug identifier. See \code{\link{sizes}()} for
a complete list. Default: 512mb, the smallest}

\item{image}{(character/numeric) The image ID of a public or private image,
or the unique slug identifier for a public image. This image will be the
base image for your droplet. See \code{\link{images}()} for a complete
list. Default: ubuntu-14-04-x64}

\item{region}{(character) The unique slug identifier for the region that you
wish to deploy in. See \code{\link{regions}()} for a complete list.
Default: sfo1}

\item{ssh_keys}{(character) A character vector of key names, an integer
vector of key ids, or NULL, to use all keys in your account. Accounts
with the corresponding private key will be able to log in to the droplet.
See \code{\link{keys}()} for a list of the keys that you've added.
Default: NULL.}

\item{backups}{(logical) Enable backups. A boolean indicating whether
automated backups should be enabled for the droplet. Automated backups can
only be enabled when the droplet is created, and cost extra.
Default: FALSE}

\item{ipv6}{(logical) A boolean indicating whether IPv6 is enabled on the
droplet.}

\item{private_networking}{(logical) Use private networking. Private
networking is currently only available in certain regions. Default: FALSE}

\item{user_data}{(character) Gets passed to the droplet at boot time. Not
all regions have this enabled, and is not used by all images.}

\item{cloud_config}{(character) Specify the name of a cloud config template
to automatically generate \code{\link{cloud_config}} and submit in
user metadata. Setting this is best practice: the built-in templates
use security best practices (disabling root log-in, security autoupdates)
to make it harder to hack your droplet.}

\item{wait}{If \code{TRUE} (default), wait until droplet has been initialised and
is ready for use.}

\item{...}{Additional options passed down to \code{\link[httr]{POST}}}
}
\description{
There are defaults for each of size, image, and region so that a quick one-liner with one
parameter is possible: simply specify the name of the droplet and your'e up and running.
}
\details{
Note that if you exit the R session or kill the function call after it's
in waiting process (the string of ...), the droplet creation will continue.
}
\examples{
\dontrun{
droplet_create()
droplet_create('droppinit')
droplet_create(name="newdrop", size = '512mb', image = 'ubuntu-14-04-x64', region = 'sfo1')
droplet_create(ssh_keys=89103)
}
}

