% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/core-functions.R
\docType{methods}
\name{prepExecution}
\alias{prepExecution}
\alias{prepExecution,BaseAnalysisPipeline-method}
\title{Prepare the pipleline for execution}
\usage{
prepExecution(object)

\S4method{prepExecution}{BaseAnalysisPipeline}(object)
}
\arguments{
\item{object}{A Pipeline object}
}
\value{
Updated \code{AnalysisPipeline} \code{StreamingAnalysisPipeline} object
}
\description{
Prepare the pipleline for execution
}
\details{
The pipeline is prepared for execution by identifying the graph of the pipeline as well as its topological ordering,
and dependency map in order to prepare for execution
}
\examples{
\dontrun{
library(analysisPipelines)
pipelineObj <- AnalysisPipeline(input = iris)
pipelineObj \%>>\% univarCatDistPlots(uniCol = "Species",
 priColor = "blue", optionalPlots = 0, storeOutput = T) \%>>\%
prepExecution -> pipelineObj
}
}
\seealso{
Other Package core functions: \code{\link{BaseAnalysisPipeline-class}},
  \code{\link{MetaAnalysisPipeline-class}},
  \code{\link{assessEngineSetUp}},
  \code{\link{checkSchemaMatch}},
  \code{\link{createPipelineInstance}},
  \code{\link{exportAsMetaPipeline}},
  \code{\link{generateOutput}},
  \code{\link{genericPipelineException}},
  \code{\link{getInput}}, \code{\link{getLoggerDetails}},
  \code{\link{getOutputById}},
  \code{\link{getPipelinePrototype}},
  \code{\link{getPipeline}}, \code{\link{getRegistry}},
  \code{\link{initDfBasedOnType}},
  \code{\link{initialize,BaseAnalysisPipeline-method}},
  \code{\link{loadMetaPipeline}},
  \code{\link{loadPipeline}},
  \code{\link{loadPredefinedFunctionRegistry}},
  \code{\link{loadRegistry}},
  \code{\link{registerFunction}},
  \code{\link{savePipeline}}, \code{\link{saveRegistry}},
  \code{\link{setInput}}, \code{\link{setLoggerDetails}},
  \code{\link{updateObject}},
  \code{\link{visualizePipeline}}
}
\concept{Package core functions}
