% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exported_functions.R
\name{getAccountInfo}
\alias{getAccountInfo}
\title{getAccountInfo}
\usage{
getAccountInfo(auth)
}
\arguments{
\item{auth}{Authentication instance. result of \code{\link{authenticate}} function}
}
\value{
R data frame containing one row per account 'auth' has access to (account id (\code{acct.id}), account name (\code{acct.name}), and additional info)
}
\description{
Get info (name, id, description) on all accounts a user has access to
}
\examples{
username <- "demo.user@demoanametrix.com"
password <- "password"
if (!authenticationCheck(auth)) 
auth <- authenticate("https://demo.anametrix.com/api", username, password)
acct.df <- getAccountInfo(auth)

}
\seealso{
Other metadata functions: \code{\link{getDatasuiteInfo}},
  \code{\link{getDetailedInfo}},
  \code{\link{getReplacementNames}},
  \code{\link{getSegmentInfo}}, \code{\link{getTableInfo}},
  \code{\link{getVariableInfo}}
}

