% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exported_functions.R
\name{getDatasuiteInfo}
\alias{getDatasuiteInfo}
\title{getDatasuiteInfo}
\usage{
getDatasuiteInfo(auth)
}
\arguments{
\item{auth}{Authentication instance. result of \code{\link{authenticate}} function}
}
\value{
R data frame containing one row per datasuite 'auth' has access to.
}
\description{
Get info (name, id, description) on all datasuites a user has access to (for all accounts)
}
\examples{
username <- "demo.user@demoanametrix.com"
password <- "password"
if (!authenticationCheck(auth)) 
auth <- authenticate("https://demo.anametrix.com/api", username, password)
datasuites.df <- getDatasuiteInfo(auth)

}
\seealso{
Other metadata functions: \code{\link{getAccountInfo}},
  \code{\link{getDetailedInfo}},
  \code{\link{getReplacementNames}},
  \code{\link{getSegmentInfo}}, \code{\link{getTableInfo}},
  \code{\link{getVariableInfo}}
}

