% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exported_functions.R
\name{getDetailedInfo}
\alias{getDetailedInfo}
\title{getDetailedInfo}
\usage{
getDetailedInfo(auth, account.name)
}
\arguments{
\item{auth}{Authentication instance. result of \code{\link{authenticate}} function}

\item{account.name}{Name of the account for which to get metadata (column \code{acct.name} from the result of the function \code{getAccountInfo})}
}
\value{
list of dataframes with detailed metadata. One element per datasuite of account.name.
}
\description{
Get all detailed matadata info for one account (datasuites/tables/column names level).
}
\examples{
username <- "demo.user@demoanametrix.com"
password <- "password"
if (!authenticationCheck(auth)) 
auth <- authenticate("https://demo.anametrix.com/api", username, password)
acct.detailed.info <- getDetailedInfo(auth, account.name = "Demo")

}
\seealso{
Other metadata functions: \code{\link{getAccountInfo}},
  \code{\link{getDatasuiteInfo}},
  \code{\link{getReplacementNames}},
  \code{\link{getSegmentInfo}}, \code{\link{getTableInfo}},
  \code{\link{getVariableInfo}}
}

