% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convertMDresults.R
\name{convertMDResultsSimple}
\alias{convertMDResultsSimple}
\title{Quickly flatten output from MegaDetector}
\usage{
convertMDResultsSimple(mdresults)
}
\arguments{
\item{mdresults}{list of bounding boxes for each image}
}
\value{
A dataframe with one entry for each bounding box
}
\description{
Returns a dataframe where each row is a MD bounding box, does not take into consideration
potential collisions with the outer edge of the image.
}
\examples{
\dontrun{
 images<-read_exif(imagedir,tags=c("filename","directory","DateTimeOriginal","FileModifyDate"),
                   recursive = TRUE)
 colnames(images)[1]<-"FilePath"
 mdsession<-loadMDModel(mdmodel)
 mdres<-classifyImagesBatchMD(mdsession,images$FilePath,
                              resultsfile=mdresultsfile,checkpoint = 2500)
 mdresflat<-convertMDResultsSimple(mdres)
}
}
