% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/auto.R
\name{sqlite.auto.build}
\alias{sqlite.auto.build}
\title{Build annovarR database in sqlite (auto from extdata/config/database.toml)}
\usage{
sqlite.auto.build(anno.name = "", buildver = "hg19",
  database.dir = "/path/", overwrite = FALSE, append = FALSE,
  index = "chr_start_index", db.type = "sqlite",
  database.cfg = system.file("extdata", "config/databases.toml", package =
  "annovarR"), extra_fread_params = list(sep = "\\t", header = TRUE, return_1L
  = FALSE), sqlite.build.params = list(fread.params = list(sep = "\\t")),
  batch_lines = 1e+07, start_index = 1, new.colnames = NULL,
  verbose = TRUE)
}
\arguments{
\item{anno.name}{Annotation name, eg. avsnp138, avsnp147, 1000g2015aug_all}

\item{buildver}{Genome version, hg19, hg38, mm10 and others}

\item{database.dir}{Dir of the databases}

\item{overwrite}{Logical indicating wheather overwrite sqlite database, default is FALSE}

\item{append}{Logical indicating wheather append the data to sqlite database, 
default is FALSE}

\item{index}{Index name in sqlite}

\item{db.type}{Setting the database type (sqlite, txt or mysql)}

\item{database.cfg}{Configuration file of annovarR databases infomation}

\item{extra_fread_params}{Pass to \code{\link[ngstk]{batch_file}}, 
default is to get value from database.cfg}

\item{sqlite.build.params}{Extra params pass to \code{\link{sqlite.build}}}

\item{batch_lines}{Parameters pass to \code{\link[ngstk]{batch_file}}, 
default is 10000000}

\item{start_index}{default is 1, control the skip rows, n = (i-1) * batch_lines}

\item{new.colnames}{Use the fread determined colnames or use new colnames}

\item{verbose}{Logical indicating wheather print the extra log infomation}
}
\description{
Build annovarR database in sqlite (auto from extdata/config/database.toml)
}
\examples{
i <- 'hg19_avsnp147'
database <- system.file('extdata', sprintf('demo/\%s.txt', i), package = 'annovarR')
file.copy(database, sprintf('\%s/\%s.txt', tempdir(), i))
sqlite.auto.build('avsnp147', 'hg19', database.dir = tempdir(), verbose = TRUE)
unlink(sprintf('\%s/\%s.txt', tempdir(), i))
unlink(sprintf('\%s/\%s.sqlite', tempdir(), i))
}
