% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/anomalize-package.R
\docType{package}
\name{anomalize_package}
\alias{anomalize_package}
\title{anomalize: Tidy anomaly detection}
\description{
The 'anomalize' package enables a "tidy" workflow for detecting anomalies in data.
The main functions are time_decompose(), anomalize(), and time_recompose().
When combined, it's quite simple to decompose time series, detect anomalies,
and create bands separating the "normal" data from the anomalous data at scale (i.e. for multiple time series).
Time series decomposition is used to remove trend and seasonal components via the time_decompose() function
and methods include seasonal decomposition of time series by Loess and
seasonal decomposition by piecewise medians. The anomalize() function implements
two methods for anomaly detection of residuals including using an inner quartile range
and generalized extreme studentized deviation. These methods are based on
those used in the \code{forecast} package and the Twitter \code{AnomalyDetection} package.
Refer to the associated functions for specific references for these methods.
}
\details{
To learn more about \code{anomalize}, start with the vignettes:
\code{browseVignettes(package = "anomalize")}
}
