% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tierney.R
\name{tierney}
\alias{tierney}
\title{tierney}
\usage{
tierney(X, burnin = 10)
}
\arguments{
\item{X}{A numeric matrix containing the data to be transformed.}

\item{burnin}{Specifies the period used to stabalise the quantile estimates. The default value is 10.}
}
\value{
A numeric matrix containing the transformed data.
}
\description{
Transforms the data X by centring and scaling using \eqn{X_{ij}^{'} = \frac{X_{ij}-\mu_{ij}}{\sigma_{ij}}} where \eqn{\mu_{ij}} and \eqn{\sigma_{ij}} are robust quantile based 
sequential estimates for the mean and standard deviation of each variate (column) \eqn{X_{i}} of X calculated up to time j. The estimates \eqn{\mu_{ij}} and \eqn{\sigma_{ij}} are
calculated from sequential estimates for the median and inter-quartile range developed by Tierney et al (1983).  This method is the default value for the
transform argument used by the \code{\link{scapa.uv}} function.
}
\examples{
library(anomaly)
data(machinetemp)
attach(machinetemp)
plot(temperature)
temperature<-tierney(temperature,burnin=4305)
plot(temperature)
}
\references{
\insertRef{Schruben:1983:OTI:2771114.2771123}{anomaly}
}
