/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.JRI;

import java.util.Vector;
import org.rosuda.JRI.REXP;
import org.rosuda.JRI.RVector;

public class RList {
    public REXP head;
    public REXP body;
    public REXP tag;
    String[] keys = null;
    REXP[] values = null;
    boolean dirtyCache = true;

    public RList() {
        this.tag = null;
        this.body = null;
        this.head = null;
    }

    public RList(RVector rVector) {
        Vector vector = rVector.getNames();
        if (vector != null) {
            this.keys = new String[vector.size()];
            vector.copyInto(this.keys);
        }
        this.values = new REXP[rVector.size()];
        rVector.copyInto(this.values);
        this.dirtyCache = false;
    }

    public RList(REXP rEXP, REXP rEXP2) {
        this.head = rEXP;
        this.body = rEXP2;
        this.tag = null;
    }

    public RList(REXP rEXP, REXP rEXP2, REXP rEXP3) {
        this.head = rEXP;
        this.body = rEXP3;
        this.tag = rEXP2;
    }

    public REXP getHead() {
        return this.head;
    }

    public REXP getBody() {
        return this.body;
    }

    public REXP getTag() {
        return this.tag;
    }

    boolean updateVec() {
        REXP rEXP;
        if (!this.dirtyCache) {
            return true;
        }
        RList rList = this;
        int n = 0;
        while (rList != null) {
            ++n;
            rEXP = rList.getBody();
            rList = rEXP == null ? null : rEXP.asList();
        }
        this.keys = new String[n];
        this.values = new REXP[n];
        rList = this;
        n = 0;
        while (rList != null) {
            rEXP = rList.getTag();
            if (rEXP != null) {
                this.keys[n] = rEXP.asSymbolName();
            }
            this.values[n] = rList.getHead();
            REXP rEXP2 = rList.getBody();
            rList = rEXP2 == null ? null : rEXP2.asList();
            ++n;
        }
        this.dirtyCache = false;
        return true;
    }

    public REXP at(String string) {
        if (!this.updateVec() || this.keys == null || this.values == null) {
            return null;
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (this.keys[i].compareTo(string) != 0) continue;
            return this.values[i];
        }
        return null;
    }

    public REXP at(int n) {
        return !this.updateVec() || this.values == null || n < 0 || n >= this.values.length ? null : this.values[n];
    }

    public String[] keys() {
        return !this.updateVec() ? null : this.keys;
    }
}

