% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/writeHydroValues.R
\name{writeIniHydro}
\alias{writeIniHydro}
\title{Edit hydro.ini values}
\usage{
writeIniHydro(area, params, mode = "other", opts = antaresRead::simOptions())
}
\arguments{
\item{area}{The area where to edit the values.}

\item{params}{The list data must have specific names and specific types :
\itemize{
\item \code{follow load} : logical or NULL
\item \code{use heuristic} : logical or NULL
\item \code{use water} : logical or NULL
\item \code{hard bounds} : logical or NULL
\item \code{use leeway} : logical or NULL
\item \code{power to level} : logical or NULL
\item \code{reservoir} : logical or NULL
\item \code{inter-daily-breakdown} : numeric, integer or NULL
\item \code{intra-daily-modulation} : numeric, integer or NULL
\item \code{inter-monthly-breakdown} : numeric, integer or NULL
\item \code{leeway low} : numeric, integer or NULL
\item \code{leeway up} : numeric, integer or NULL
\item \code{pumping efficiency} : numeric, integer or NULL
\item \code{initialize reservoir date} : numeric, integer or NULL
\item \code{reservoir capacity} : numeric, integer or NULL
}}

\item{mode}{Execution mode. Useful when you create a new area or remove an existing area to avoid control on hydro data.}

\item{opts}{List of simulation parameters returned by the function
\code{\link[antaresRead:setSimulationPath]{antaresRead::setSimulationPath()}}.}
}
\description{
\ifelse{html}{\figure{badge_api_ok.svg}{options: alt='Antares API OK'}}{Antares API: \strong{OK}}

For a given area, write its data in the hydro.ini file.
}
\section{Warning}{

For an \strong{Antares version >= 860}, control of data consistency between \code{mingen.txt} and \code{mod.txt} can be executed.

For an \strong{Antares version >= 860}, control of data consistency between \code{mingen.txt} and \verb{maxpower_<area>.txt} can be executed.

These controls depend on the values you find in \code{hydro.ini} file.
}

\examples{
\dontrun{
opts <- setSimulationPath(studypath, simulation = "input")
createArea("fictive_area") 
writeIniHydro(area = "fictive_area"
, params = list("leeway low" = 2.5, "leeway up" = 25))

}

}
