% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sample-by-category.R
\name{categorical_sampling}
\alias{categorical_sampling}
\title{Random sampling employing a categorical constraint}
\usage{
categorical_sampling(categories, K)
}
\arguments{
\item{categories}{A matrix or vector of one or more categorical variables.}

\item{K}{The number of groups that are returned.}
}
\value{
A vector representing the sample each element was assigned to.
}
\description{
This function can be used to obtain a stratified split of a data set.
}
\details{
This function can be used to obtain a stratified split of a data set. 
Using this function is like calling a\code{\link{anticlustering}}` with 
argument `categories` where no optimization is conducted; the categories are 
just evenly split between samples. Apart from the restriction that categories 
are balanced between samples, the split is random.
}
\examples{

data(schaper2019)
categories <- schaper2019$room
groups <- categorical_sampling(categories, K = 6)
table(groups, categories)

}
