% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SummaryMethods.R
\docType{methods}
\name{summary-methods}
\alias{summary-methods}
\alias{summary,ANY-method}
\alias{summary,AIDS-method}
\alias{summary,Bertrand-method}
\alias{summary,Auction2ndLogit-method}
\alias{summary,Cournot-method}
\alias{summary,Auction2ndCap-method}
\alias{summary,VertBargBertLogit-method}
\title{Summary Methods}
\usage{
\S4method{summary}{Bertrand}(
  object,
  revenue = TRUE,
  shares = TRUE,
  levels = FALSE,
  parameters = FALSE,
  market = FALSE,
  insideOnly = TRUE,
  digits = 2,
  ...
)

\S4method{summary}{VertBargBertLogit}(
  object,
  revenue = TRUE,
  levels = FALSE,
  parameters = FALSE,
  market = FALSE,
  insideOnly = TRUE,
  digits = 2,
  ...
)

\S4method{summary}{Auction2ndCap}(object, exAnte = FALSE, parameters = FALSE, market = TRUE, digits = 2)

\S4method{summary}{Cournot}(
  object,
  market = FALSE,
  revenue = FALSE,
  shares = FALSE,
  levels = FALSE,
  parameters = FALSE,
  digits = 2,
  ...
)

\S4method{summary}{Auction2ndLogit}(object, levels = TRUE, revenue = FALSE, ...)
}
\arguments{
\item{object}{an instance of class  \code{Bertrand}, \code{Auction2ndCap}, \code{Cournot}, or \code{Auction2ndLogit}}

\item{revenue}{When TRUE, returns revenues, when FALSE returns quantitities. Default is TRUE.}

\item{shares}{When TRUE, returns shares, when FALSE returns quantities (when possible). Default is TRUE.}

\item{levels}{When TRUE, returns changes in levels rather than percents and quantities rather than shares, when FALSE, returns
changes as a percent and shares rather than quantities. Default is FALSE.}

\item{parameters}{When TRUE, displays all demand parameters. Default is FALSE.}

\item{market}{When TRUE, displays aggregate information about the effect of a tariff.
When FALSE displays product-specific (or in the case of Cournot, plant-specific) effects.
Default is FALSE.}

\item{insideOnly}{When TRUE, rescales shares on inside goods to sum to 1. Default is FALSE.}

\item{digits}{Number of significant digits to report. Default is 2.}

\item{...}{Allows other objects to be passed to a \code{CV} method.}

\item{exAnte}{If \sQuote{exAnte} equals TRUE then the
\emph{ex ante} expected result for each firm is produced, while FALSE produces the
expected result conditional on each firm winning the auction. Default is FALSE.}
}
\description{
Summary methods for the \code{Bertrand}, \code{Auction2ndCap},  \code{Cournot}, and \code{Auction2ndLogit} classes.
Summarizes the effect of the merger, including price and revenue changes.
}
\keyword{methods}
