% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/apex-utils.R
\name{ax_yaxis}
\alias{ax_yaxis}
\title{Y-axis options}
\usage{
ax_yaxis(
  ax,
  opposite = NULL,
  tickAmount = NULL,
  max = NULL,
  min = NULL,
  floating = NULL,
  labels = NULL,
  axisBorder = NULL,
  axisTicks = NULL,
  title = NULL,
  tooltip = NULL,
  crosshairs = NULL,
  ...
)
}
\arguments{
\item{ax}{A \code{apexcharts} \code{htmlwidget} object.}

\item{opposite}{Logical. When enabled, will draw the yaxis on the right side of the chart.}

\item{tickAmount}{Number of Tick Intervals to show.}

\item{max}{Lowest number to be set for the y-axis. The graph drawing beyond this number will be clipped off.}

\item{min}{Highest number to be set for the y-axis. The graph drawing beyond this number will be clipped off.}

\item{floating}{Logical. Floating takes y-axis is taken out of normal flow and places y-axis on svg element directly,
similar to an absolutely positioned element. Set the offsetX and offsetY then to adjust the position manually}

\item{labels}{A list of parameters.}

\item{axisBorder}{A list of parameters.}

\item{axisTicks}{A list of parameters.}

\item{title}{A list of parameters.}

\item{tooltip}{A list of parameters.}

\item{crosshairs}{A list of parameters.}

\item{...}{Additional parameters.}
}
\value{
A \code{apexcharts} \code{htmlwidget} object.
}
\description{
Y-axis options
}
\note{
See \url{https://apexcharts.com/docs/options/yaxis/}
}
\examples{
data("economics_long", package = "ggplot2")
apex(
  data = economics_long,
  mapping = aes(x = date, y = value01, group = variable),
  type = "line"
) \%>\%
  ax_yaxis(
    decimalsInFloat = 2, title = list(text = "Rescaled to [0,1]")
  )
  
# Format tick labels
temperature <- data.frame(
  month = head(month.name),
  tp = c(4, -2, 2, 7, 11, 14)
)
apex(temperature, aes(month, tp), "line") \%>\% 
  ax_yaxis(
    labels = list(
      formatter = htmlwidgets::JS("function(value) {return value + 'Â°C';}")
    )
  )
}
