% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/annotations.R
\name{add_event_marker}
\alias{add_event_marker}
\title{Add an event marker to a chart}
\usage{
add_event_marker(
  ax,
  when,
  y,
  size = 5,
  color = "#000",
  fill = "#FFF",
  width = 2,
  shape = "circle",
  radius = 2,
  label = NULL,
  ...
)
}
\arguments{
\item{ax}{An \code{apexcharts} \code{htmlwidget} object.}

\item{when}{Vector of position to place the event.}

\item{y}{Coordinate(s) on the y-axis.}

\item{size}{Size of the marker.}

\item{color}{Stroke Color of the marker point.}

\item{fill}{Fill Color of the marker point.}

\item{width}{Stroke Size of the marker point.}

\item{shape}{Shape of the marker: \code{"circle"} or \code{"square"}.}

\item{radius}{Radius of the marker (applies to square shape).}

\item{label}{Add a label to the shade, use a \code{character}
or see \code{\link{label}} for more controls.}

\item{...}{Additional arguments, see
\url{https://apexcharts.com/docs/options/annotations/} for possible options.}
}
\value{
An \code{apexcharts} \code{htmlwidget} object.
}
\description{
Add a point with a label based on a datetime.
}
\examples{
library(apexcharter)
data("consumption")

# add a marker
apex(consumption, aes(date, value, group = type), "spline") \%>\% 
  add_event_marker(when = "2020-01-22", y = 1805)

# with a label
apex(consumption, aes(date, value, group = type), "spline") \%>\% 
  add_event_marker(when = "2020-01-22", y = 1805, label = "Consumption peak")

# add several markers
apex(consumption, aes(date, value, group = type), "spline") \%>\% 
  add_event_marker(
    when = c("2020-01-02", "2020-01-06", "2020-01-13", 
             "2020-01-22", "2020-01-28", "2020-02-06",
             "2020-02-13", "2020-02-19", "2020-02-27"),
    y = c(1545, 1659, 1614,
          1805, 1637, 1636, 
          1597, 1547, 1631),
    size = 10,
    color = "firebrick"
  )
}
\seealso{
\code{\link{add_event}} to add a vertical line.
}
