% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R, R/cv.R
\name{auc}
\alias{auc}
\alias{print.aphylo_auc}
\alias{plot.aphylo_auc}
\title{Area Under the Curve and Receiving Operating Curve}
\usage{
auc(pred, labels, nc = 200L, nine_na = TRUE)

\method{print}{aphylo_auc}(x, ...)

\method{plot}{aphylo_auc}(x, y = NULL, ...)
}
\arguments{
\item{pred}{A numeric vector with the predictions of the model. Values must
range between 0 and 1.}

\item{labels}{An integer vector with the labels (truth). Values should be either
0 or 1.}

\item{nc}{Integer. Number of cutoffs to use for computing the rates and AUC.}

\item{nine_na}{Logical. When \code{TRUE}, 9 is treated as \code{NA}.}

\item{x}{An object of class \code{aphylo_auc}.}

\item{...}{Further arguments passed to the method.}

\item{y}{Ignored.}
}
\value{
A list:
\itemize{
\item \code{tpr} A vector of length \code{nc} with the True Positive Rates.
\item \code{tnr} A vector of length \code{nc} with the True Negative Rates.
\item \code{fpr} A vector of length \code{nc} with the False Positive Rates.
\item \code{fnr} A vector of length \code{nc} with the False Negative Rates.
\item \code{auc} A numeric value. Area Under the Curve.
\item \code{cutoffs} A vector of length \code{nc} with the cutoffs used.
}
}
\description{
The AUC values are computed by approximation using the area of the polygons formed
under the ROC curve.
}
\examples{
set.seed(8381)
x   <- rdrop_annotations(raphylo(50), .3)
ans <- aphylo_mcmc(x ~ mu_d + mu_s + Pi)
ans_auc <- auc(predict(ans, loo = TRUE), x[,1,drop=TRUE])
print(ans_auc)
plot(ans_auc)
}
