% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/apollo_validatecontrol.R
\name{apollo_validatecontrol}
\alias{apollo_validatecontrol}
\title{Validates apollo_control}
\usage{
apollo_validatecontrol(database, apollo_control)
}
\arguments{
\item{database}{data.frame. Data used by model.}

\item{apollo_control}{List. Options controlling the running of the code.
\describe{
  \item{modelName}{Character. Name of the model. Used when saving the output to files.}
  \item{modelDescr}{Character. Description of the model. Used in output files.}
  \item{indivID}{Character. Name of column in the database with each decision maker's ID.}
  \item{mixing}{Boolean. TRUE for models that include random parameters.}
  \item{nCores}{Numeric>0. Number of cores to use in calculations of the model likelihood.}
  \item{seed}{Numeric. Seed for random number generation.}
  \item{HB}{Boolean. TRUE if using RSGHB for Bayesian estimation of model.}
  \item{noValidation}{Boolean. TRUE if user does not wish model input to be validated before estimation - FALSE by default.}
  \item{noDiagnostics}{Boolean. TRUE if user does not wish model diagnostics to be printed - FALSE by default.}
}}
}
\value{
Validated version of apollo_control, with additional element called panelData set to TRUE for repeated choice data.
}
\description{
Validates the options controlling the running of the code \code{apollo_control} and sets default values for the omitted ones.
}
\details{
This function should be run before running \code{apollo_validatedata}.
}
