% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/apollo_sharesTest.R
\name{apollo_sharesTest}
\alias{apollo_sharesTest}
\title{Compares predicted and observed shares}
\usage{
apollo_sharesTest(
  model,
  apollo_probabilities,
  apollo_inputs,
  sharesTest_settings
)
}
\arguments{
\item{model}{Model object. Estimated model object as returned by function \link{apollo_estimate}.}

\item{apollo_probabilities}{Function. Returns probabilities of the model to be estimated. Must receive three arguments:
\itemize{
  \item \code{apollo_beta}: Named numeric vector. Names and values of model parameters.
  \item \code{apollo_inputs}: List containing options of the model. See \link{apollo_validateInputs}.
  \item \code{functionality}: Character. Can be either "estimate" (default), "prediction", "validate", "conditionals", "zero_LL", or "raw".
}}

\item{apollo_inputs}{List grouping most common inputs. Created by function \link{apollo_validateInputs}.}

\item{sharesTest_settings}{List of arguments. It must include the following.
\itemize{
  \item \code{alternatives}: Named numeric vector. Names of alternatives and their corresponding value in \code{choiceVar}.
  \item \code{choiceVar}: Numeric vector. Contains choices for all observations. It will usually be a column from the database. Values are defined in \code{alternatives}.
  \item \code{subsamples}: Named list of boolean vectors. Each element of the list defines whether a given observation belongs to a given subsample (e.g. by sociodemographics).
  \item \code{modelComponent}: Name of model component. Set to model by default.
  \item \code{newAlts}: Optional list describing the new alternatives to be used by apollo_sharesTest. This should have as many elements as new alternatives, with each entry being a matrix of 0-1 entries, with one row per observation, and one column per alternative used in the model.
  \item \code{newAltsOnly}: Boolean. If TRUE, results will only be printed for the 'new' alternatives defined in newAlts, not the original alternatives used in the model. Set to FALSE by default.
}}
}
\value{
Nothing
}
\description{
Prints tables comparing the shares predicted by the model with the shares observed in the data.
}
\details{
This is an auxiliary function to help guide the definition of utility functions in a choice model. 
By comparing the predicted and observed shares of alternatives for different categories of the data, 
it is possible to identify what additional explanatory variables could improve the fit of the model.
}
