% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cost_calculation.R
\name{cost_calc}
\alias{cost_calc}
\title{Calculate cost matrix}
\usage{
cost_calc(X, Y, ground_p)
}
\arguments{
\item{X}{matrix of values in first sample. Observations should be by column, not rows.}

\item{Y}{matrix of Values in second sample. Observations should be by column, not rows.}

\item{ground_p}{power of the Lp norm to use in cost calculation.}
}
\value{
matrix of costs
}
\description{
Calculate cost matrix
}
\examples{
X <- matrix(rnorm(10*100), 10, 100)
Y <- matrix(rnorm(10*100), 10, 100)
# the Euclidean distance
cost <- cost_calc(X, Y, ground_p = 2)
}
