% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hilbert.projection.R
\name{hilbert.projection}
\alias{hilbert.projection}
\title{Get order along the Hilbert curve}
\usage{
hilbert.projection(X, Sigma = NULL)
}
\arguments{
\item{X}{matrix of values. Observations are unique by rows.}

\item{Sigma}{Covariance of the data. If provided, uses a Mahalanobis distance.}
}
\value{
Index of orders
}
\description{
Get order along the Hilbert curve
}
\examples{
X <- matrix(rnorm(10*3), 3, 10)
idx <- hilbert.projection(X)
print(idx)
}
