% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract_data_apsimx.R
\name{extract_values_apsimx}
\alias{extract_values_apsimx}
\title{Extract values from a parameter path}
\usage{
extract_values_apsimx(file, src.dir, parm.path)
}
\arguments{
\item{file}{file name to be run (the extension .apsimx is optional)}

\item{src.dir}{directory containing the .apsimx file to be run (defaults to the current directory)}

\item{parm.path}{parameter path either use inspect_apsimx or see example below}
}
\value{
a vector with extracted parameter values from an APSIM file.
}
\description{
Extract initial values from a parameter path
}
\examples{
\donttest{
## Find examples
extd.dir <- system.file("extdata", package = "apsimx")
## Extract parameter path
pp <- inspect_apsimx("Maize.apsimx", src.dir = extd.dir,
                     node = "Manager", parm = list("Fert", 1))
ppa <- paste0(pp, ".Amount")
## Extract value
extract_values_apsimx("Maize.apsimx", src.dir = extd.dir, parm.path = ppa)
}
}
