% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/split.R
\name{split,SoilProfileCollection-method}
\alias{split,SoilProfileCollection-method}
\title{Split a SoilProfileCollection object into a list of SoilProfileCollection objects.}
\usage{
\S4method{split}{SoilProfileCollection}(x, f, drop = TRUE, ...)
}
\arguments{
\item{x}{a SoilProfileCollection object}

\item{f}{a character vector naming a single site-level attribute that defines groups, a ‘factor’ in the sense that \code{as.factor(f)} defines the grouping, or a list of such factors in which case their interaction is used for the grouping.}

\item{drop}{logical indicating if levels that do not occur should be dropped (if f is a factor or a list).}

\item{...}{Additional arguments are ignored}
}
\value{
A list of SoilProfileCollections or \code{NULL} for empty result.
}
\description{
This function splits a SoilProfileCollection into a list of SoilProfileCollection objects using a site-level attribute to define groups or profile ID (idname(x)).
}
\details{
As of aqp 1.25, omission of \code{f} argument is no longer possible, as the base R generic is overloaded by this SoilProfileCollection method. This used to result in an "identity" split, according to \code{idname(x)}, e.g. a list as long as \code{length(x)}, with a single-profile SoilProfileCollection per list element. Replicate this behavior using \code{f = idname(x)} or \code{f = profile_id(x)}
}
\examples{

data(sp2)
depths(sp2) <- id ~ top + bottom

# add a more interesting site-level attribute
site(sp2) <- ~ surface

# using identity site-level attribute (profile ID)
p1 <- split(sp2, f = idname(sp2))
names(p1)
length(p1)

# using vector equal in length to number of profiles (profile ID, again)
p2 <- split(sp2, f = profile_id(sp2))
names(p2)
length(p2)

# which are both equivalent to setting `f` to NULL
p3 <- split(sp2, f = NULL)
names(p3)
length(p3)

# split on surface (age) site-level var
p4 <- split(sp2, f = "surface")
names(p4) 
length(p4) # 5 unique "surfaces", 5 SPCs in result list

}
\author{
D.E Beaudette
}
