% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aggregateColorPlot.R
\name{aggregateColorPlot}
\alias{aggregateColorPlot}
\title{Plot aggregate soil color data}
\usage{
aggregateColorPlot(
  x,
  print.label = TRUE,
  label.font = 1,
  label.cex = 0.65,
  label.orientation = c("v", "h"),
  buffer.pct = 0.02,
  print.n.hz = FALSE,
  rect.border = "black",
  horizontal.borders = FALSE,
  horizontal.border.lwd = 2,
  x.axis = TRUE,
  y.axis = TRUE,
  ...
)
}
\arguments{
\item{x}{a \code{list}, results from \code{aggregateColor()}}

\item{print.label}{logical, print Munsell color labels inside of rectangles, only if they fit}

\item{label.font}{font specification for color labels}

\item{label.cex}{font size for color labels}

\item{label.orientation}{label orientation, \code{v} for vertical or \code{h} for horizontal}

\item{buffer.pct}{extra space between labels and color rectangles}

\item{print.n.hz}{optionally print the number of horizons below Munsell color labels}

\item{rect.border}{color for rectangle border}

\item{horizontal.borders}{optionally add horizontal borders between bands of color}

\item{horizontal.border.lwd}{line width for horizontal borders}

\item{x.axis}{logical, add a scale and label to x-axis?}

\item{y.axis}{logical, add group labels to y-axis?}

\item{...}{additional arguments passed to \code{plot}}
}
\value{
no data are returned, function is called for graphical output
}
\description{
Generate a plot from summaries generated by \code{aggregateColor()}.
}
\details{
See the \href{http://ncss-tech.github.io/AQP/sharpshootR/aggregate-soil-color.html}{related tutorial for additional examples}.
}
\examples{

# keep examples from using more than 2 cores
data.table::setDTthreads(Sys.getenv("OMP_THREAD_LIMIT", unset = 2))

# load some example data
data(sp1, package = 'aqp')

# upgrade to SoilProfileCollection and convert Munsell colors
sp1$soil_color <- with(sp1, munsell2rgb(hue, value, chroma))
depths(sp1) <- id ~ top + bottom
site(sp1) <- ~ group

# generalize horizon names
n <- c('O', 'A', 'B', 'C')
p <- c('O', 'A', 'B', 'C')
sp1$genhz <- generalize.hz(sp1$name, n, p)

# aggregate colors over horizon-level attribute: 'genhz'
a <- aggregateColor(sp1, groups = 'genhz', col = 'soil_color')

# check results
str(a)

# simple visualization
aggregateColorPlot(a)

}
\author{
D.E. Beaudette
}
\keyword{hplots}
