% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/util-parse-esri-json.R
\name{parse_esri_json}
\alias{parse_esri_json}
\title{Parse Esri JSON}
\usage{
parse_esri_json(string, ...)
}
\arguments{
\item{string}{the raw Esri JSON string.}

\item{...}{additional arguments passed to \code{\link[RcppSimdJson:fparse]{RcppSimdJson::fparse}}}
}
\value{
A data.frame. If geometry is found, returns an sf object.
}
\description{
Parses an Esri FeatureSet JSON object into an R object. If there is no
geometry present, a data.frame is returned. If there is geometry, an sf object is returned.
}
\examples{

esri_json <- '{
    "geometryType": "esriGeometryPolygon",
    "spatialReference": {
        "wkid": 4326
    },
    "hasZ": false,
    "hasM": false,
    "features": [
        {
            "attributes": {
                "id": 1
            },
            "geometry": {
                "rings": [
                    [
                        [0.0, 0.0],
                        [1.0, 0.0],
                        [1.0, 1.0],
                        [0.0, 1.0],
                        [0.0, 0.0]
                    ]
                ]
            }
        }
    ]
}'

parse_esri_json(esri_json)

}
