% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/createMDGallery.R
\name{createMDGallery}
\alias{createMDGallery}
\title{Create the Summary for Each Artifact in a Markdown Format}
\usage{
createMDGallery(
  output,
  repo = aoptions("repo"),
  user = aoptions("user"),
  branch = aoptions("branch"),
  subdir = aoptions("subdir"),
  repoType = aoptions("repoType"),
  addTags = FALSE,
  addMiniature = FALSE,
  maxTags = 100
)
}
\arguments{
\item{output}{A name of the file in which artifacts should be summarized.}

\item{repo}{A character containing a name of the Remote repository on which the Repository is stored.
By default set to \code{NULL} - see \code{Note}.}

\item{user}{A character containing a name of the Github user on whose account the \code{repo} is created.
By default set to \code{NULL} - see \code{Note}.}

\item{branch}{A character containing a name of
the Remote Repository's branch on which the Repository is stored. Default \code{branch} is \code{master}.}

\item{subdir}{A character containing a name of a directory on the Remote repository
on which the Repository is stored. If the Repository is stored in the main folder of the Remote repository, this should be set
to \code{subdir = "/"} as default.}

\item{repoType}{A character containing a type of the remote repository. Currently it can be 'github' or 'bitbucket'.}

\item{addTags}{Logical, whether to add artfiact's \link{Tags} to the \code{output}.}

\item{addMiniature}{Logical, whether to add artfiact's \code{miniature/plots} to the \code{output}.}

\item{maxTags}{Integer. The maximal length of chunks output when describing \code{Tags} of artifact.}
}
\description{
\code{createMDGallery} creates a summary for each artifact from \link{Repository} stored on a GitHub.
For each artifact tihd function creates a markdown file with: the download link, artifact's \link{Tags} (when \code{addTags = TRUE}) and
miniature (\code{addMiniature = TRUE}) if the artifact was archived with it's miniature and \code{Tags}. The miniature is a \link{print}
 or \link{head} over an artifact or it's \code{png} when it was a plot. But this function only supports \code{png} miniatures.
}
\details{
To learn more about artifacts visit \link[archivist]{archivist-package}.
}
\note{
If \code{repo} and \code{user} are set to \code{NULL} (as default) in the Remote mode then global parameters
set in \link{setRemoteRepo} (or via \link{aoptions}) function are used.
}
\section{Contact}{

 
Bug reports and feature requests can be sent to 
\href{https://github.com/pbiecek/archivist/issues}{https://github.com/pbiecek/archivist/issues}
}

\examples{
\dontrun{

createMDGallery(user = 'MarcinKosinski', repo = 'Museum',
 'README_test1.md', addTags = TRUE)
createMDGallery('graphGallery', 'pbiecek', addMiniature = TRUE,
 'README_test2.md', addTags = TRUE)

}

}
\references{
Biecek P and Kosinski M (2017). "archivist: An R Package for Managing,
Recording and Restoring Data Analysis Results." _Journal of Statistical
Software_, *82*(11), pp. 1-28. doi: 10.18637/jss.v082.i11 (URL:
http://doi.org/10.18637/jss.v082.i11).
URL https://github.com/pbiecek/archivist
}
\seealso{
Markdown example: \url{https://github.com/pbiecek/archivist/issues/144#issuecomment-174192366}

Other archivist: 
\code{\link{Repository}},
\code{\link{Tags}},
\code{\link{\%a\%}()},
\code{\link{addHooksToPrint}()},
\code{\link{addTagsRepo}()},
\code{\link{aformat}()},
\code{\link{ahistory}()},
\code{\link{alink}()},
\code{\link{aoptions}()},
\code{\link{archivist-package}},
\code{\link{areadLocal}()},
\code{\link{aread}()},
\code{\link{asearchLocal}()},
\code{\link{asearch}()},
\code{\link{asession}()},
\code{\link{atrace}()},
\code{\link{cache}()},
\code{\link{copyLocalRepo}()},
\code{\link{createLocalRepo}()},
\code{\link{deleteLocalRepo}()},
\code{\link{getRemoteHook}()},
\code{\link{getTagsLocal}()},
\code{\link{loadFromLocalRepo}()},
\code{\link{md5hash}},
\code{\link{removeTagsRepo}()},
\code{\link{restoreLibs}()},
\code{\link{rmFromLocalRepo}()},
\code{\link{saveToLocalRepo}()},
\code{\link{searchInLocalRepo}()},
\code{\link{setLocalRepo}()},
\code{\link{shinySearchInLocalRepo}()},
\code{\link{showLocalRepo}()},
\code{\link{splitTagsLocal}()},
\code{\link{summaryLocalRepo}()},
\code{\link{zipLocalRepo}()}
}
\author{
Marcin Kosinski, \email{m.p.kosinski@gmail.com}
}
\concept{archivist}
