% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_layers.R
\name{plot_layer}
\alias{plot_layer}
\title{Plot a spatial layer}
\usage{
plot_layer(sf_data, outline_poly = NULL, plot_pkg = "ggplot")
}
\arguments{
\item{sf_data}{An sf object as returned from \code{\link{get_spatial_layer}}}

\item{outline_poly}{An sf polygon to outline \code{sf_data} for context, or
\code{NULL}}

\item{plot_pkg}{Character. The plotting environment to use. Either "ggplot"
(default) or "base"}
}
\value{
Either a \code{ggplot} object or a plot
}
\description{
This function plots a spatial layer as returned from
\code{\link{get_spatial_layer}}.
}
\examples{
\dontrun{
plot_layer(iceland)
plot_layer(mke_county, outline_poly = wis_poly)
g <-
   plot_layer(wi_counties) +
   ggplot2::geom_sf(data = portage_county, fill = "red") +
   ggplot2::geom_sf(data = mke_county, fill = "red")
g
}

}
