% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/process_raster.R
\name{raster_colors,RasterBrick-method}
\alias{raster_colors,RasterBrick-method}
\title{Convert RasterBrick into data.frame of colors that can be used for plotting}
\usage{
\S4method{raster_colors}{RasterBrick}(x)
}
\arguments{
\item{x}{A RasterBrick object}
}
\value{
A data.frame with 3 columns and \code{length(raster_object)} rows
}
\description{
This function is used internally by \code{\link{plot_layer}} to convert a
RasterBrick object to a data.frame of colors for each pixel that can be used
for plotting with ggplot2. Note that this function assumes that the first
three bands in the RasterBrick objects are the RGB values and all additional
bands are ignored.
}
\examples{
\dontrun{
wi_leaf_off_layer <- get_image_layer(wi_leaf_off_url, wis_poly)
wi_leaf_off_data <- raster_colors(wi_leaf_off_layer)
}
}
