% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/arfima.R
\docType{package}
\name{arfima-package}
\alias{arfima-package}
\title{Simulates, fits, and predicts persistent and anti-persistent time series.
arfima}
\description{
Simulates with arfima.sim, fits with arfima, and predicts with a method for
the generic function.  Plots predictions and the original time series. Has
the capability to fit regressions with ARFIMA/ARIMA-FGN/ARIMA-PLA errors, as
well as transfer functions/dynamic regression.
}
\details{
\tabular{ll}{ Package: \tab arfima\cr Type: \tab Package\cr Version: \tab
1.4-0\cr Date: \tab 2017-06-20\cr License: \tab MIT \cr }

A list of functions:

\code{\link{arfima.sim}} - Simulates an ARFIMA, ARIMA-FGN, or ARIMA-PLA
(three classes of mixed ARIMA hyperbolic decay processes) process, with
possible seasonal components.

\code{\link{arfima}} - Fits an ARIMA-HD (default single-start) model to a series,
with options for regression with ARIMA-HD errors and dynamic regression
(transfer functions).  Allows for fixed parameters as well as choices for
the optimizer to be used.

\code{\link{arfima0}} - Simplified version of \code{arfima}

\code{\link{weed}} - Weeds out modes too close to each other in the same
fit.  The modes with the highest log-likelihoods are kept

\code{\link{print.arfima}} - Prints the relevant output of an \code{arfima}
fitted object, such as parameter estimates, standard errors, etc.

\code{\link{summary.arfima}} - A much more detailed version of
\code{print.arfima}

\code{\link{coef.arfima}} - Extracts the coefficients from a \code{arfima}
object

\code{\link{vcov.arfima}} - Theoretical and observed covariance matrices of
the coefficients

\code{\link{residuals.arfima}} - Extracts the residuals or regression
residuals from a \code{arfima} object

\code{\link{fitted.arfima}} - Extracts the fitted values from a
\code{arfima} object

\code{\link{tacvfARFIMA}} - Computes the theoretical autocovariance function
of a supplied model.  The model is checked for stationarity and
invertibility.

\code{\link{iARFIMA}} - Computes the Fisher information matrix of all
non-FGN components of the given model.  Can be computed (almost) exactly or
through a psi-weights approximation.  The approximation takes more time.

\code{\link{IdentInvertQ}} - Checks whether the model is identifiable,
stationary, and invertible.  Identifiability is checked through the
information matrix of all non-FGN components, as well as whether both types
of fractional noise are present, both seasonally and non-seasonally.

\code{\link{lARFIMA}} and \code{\link{lARFIMAwTF}} - Computes the
log-likelihood of a given model with a given series.  The second admits
transfer function data.

\code{\link{predict.arfima}} - Predicts from an \code{arfima} object.
Capable of exact minimum mean squared error predictions even with integer d
> 0 and/or integer dseas > 0. Does not include transfer function/leading
indicators as of yet.  Returns a \code{predarfima} object, which is composed
of: predictions, and standard errors (exact and, if possible, limiting).

\code{\link{print.predarfima}} - Prints the relevant output from a
\code{predarfima} object: the predictions and their standard deviations.

\code{\link{plot.predarfima}} - Plots a \code{predarfima} object.  This
includes the original time series, the forecasts and as default the
 standard 95\% prediction intervals (exact and, if available, limiting).

\code{\link{logLik.arfima}}, \code{\link{AIC.arfima}},
\code{\link{BIC.arfima}} - Extracts the requested values from an
\code{\link{arfima}} object

\code{\link{distance}} - Calculates the distances between the modes

\code{\link{removeMode}} - Removes a mode from a fit

\code{\link{tacvf}} - Calculates the theoretical autocovariance functions
(tacvfs) from a fitted \code{arfima} object

\code{\link{plot.tacvf}} - Plots the tacvfs

\code{\link{print.tacvf}} - Prints the tacvfs

\code{\link{tacfplot}} - Plots the theoretical autocorrelation functions
(tacfs) of different models on the same data

\code{\link{SeriesJ}}, \code{\link{tmpyr}} - Two datasets included with the
package
}
\examples{

\donttest{
set.seed(8564)
sim <- arfima.sim(1000, model = list(phi = c(0.2, 0.1), dfrac = 0.4, theta = 0.9))
fit <- arfima(sim, order = c(2, 0, 1), back=T)

fit

data(tmpyr)

fit1 <- arfima(tmpyr, order = c(1, 0, 1), numeach = c(3, 3), dmean = FALSE)
fit1

plot(tacvf(fit1), maxlag = 30, tacf = TRUE)

fit2 <- arfima(tmpyr, order = c(1, 0, 0), numeach = c(3, 3), autoweed = FALSE,
dmean = FALSE)

fit2

fit2 <- weed(fit2)

fit2

tacfplot(fits = list(fit1, fit2))

fit3 <- removeMode(fit2, 2)

fit3

coef(fit2)
vcov(fit2)

fit1fgn <- arfima(tmpyr, order = c(1, 0, 1), numeach = c(3, 3),
dmean = FALSE, lmodel = "g")
fit1fgn

fit1hd <- arfima(tmpyr, order = c(1, 0, 1), numeach = c(3, 3),
dmean = FALSE, lmodel = "h")
fit1hd

data(SeriesJ)
attach(SeriesJ)

fitTF <- arfima(YJ, order= c(2, 0, 0), xreg = XJ, reglist =
list(regpar = c(1, 2, 3)), lmodel = "n", dmean = FALSE)
fitTF

detach(SeriesJ)

set.seed(4567)

sim <- arfima.sim(1000, model = list(phi = 0.3, dfrac = 0.4, dint = 1),
sigma2 = 9)

X <- matrix(rnorm(2000), ncol = 2)

simreg <- sim + crossprod(t(X), c(2, 3))

fitreg <- arfima(simreg, order = c(1, 1, 0), xreg = X)

fitreg

plot(sim)

lines(residuals(fitreg, reg = TRUE)[[1]], col = "blue")
##pretty much a perfect match.
}

}
\references{
Veenstra, J.Q. Persistence and Antipersistence:  Theory and
Software (PhD Thesis)
}
\author{
JQ (Justin) Veenstra, A. I. McLeod

Maintainer: JQ (Justin) Veenstra <jqveenstra@gmail.com>
}
\keyword{package}
