% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/discard.R, R/replace.R
\docType{methods}
\name{infinite}
\alias{infinite}
\alias{remove_Inf}
\alias{remove_Inf-method}
\alias{replace_Inf}
\alias{replace_Inf-method}
\alias{remove_Inf,ANY-method}
\alias{replace_Inf,matrix-method}
\title{Tools for working with infinite values}
\usage{
remove_Inf(x, ...)

replace_Inf(x, ...)

\S4method{remove_Inf}{ANY}(x, margin = 1, all = FALSE)

\S4method{replace_Inf}{matrix}(x, value = 0)
}
\arguments{
\item{x}{An object (should be a \code{\link{matrix}} or a \code{\link{data.frame}}).}

\item{...}{Currently not used.}

\item{margin}{A vector giving the subscripts which the function will be
applied over (\code{1} indicates rows, \code{2} indicates columns).}

\item{all}{A \code{\link{logical}} scalar. If \code{TRUE}, only the rows/columns whose
values all meet the condition defined by \code{f} are considered. If \code{FALSE}
(the default), only rows/columns where at least one value validates the
condition defined by \code{f} are considered.}

\item{value}{A possible replacement value.}
}
\description{
\itemize{
\item \code{remove_Inf()} remove rows/columns that contain \link[=is.finite]{infinite values}.
\item \code{replace_Inf} replaces \link[=is.finite]{infinite values} values.
}
}
\examples{
## Create a count data matrix
X <- matrix(sample(1:10, 25, TRUE), nrow = 5, ncol = 5)

## Add NA
k <- sample(1:25, 3, FALSE)
X[k] <- NA
X

## Count missing values in rows
count(X, f = is.na, margin = 1)
## Count non-missing values in columns
count(X, f = is.na, margin = 2, negate = TRUE)

## Find row with NA
detect(X, f = is.na, margin = 1)
## Find column without any NA
detect(X, f = is.na, margin = 2, negate = TRUE, all = TRUE)

## Keep row without any NA
keep(X, f = is.na, margin = 1, negate = TRUE, all = TRUE)
## Keep row without any NA
keep(X, f = is.na, margin = 2, negate = TRUE, all = TRUE)

## Remove row with any NA
discard(X, f = is.na, margin = 1, all = FALSE)
## Remove column with any NA
discard(X, f = is.na, margin = 2, all = FALSE)

## Replace NA with zeros
replace_NA(X, value = 0)
}
\seealso{
Other data cleaning tools: 
\code{\link{compact}()},
\code{\link{count}()},
\code{\link{detect}()},
\code{\link{discard}()},
\code{\link{keep}()},
\code{\link{missing}},
\code{\link{zero}}
}
\author{
N. Frerebeau
}
\concept{data cleaning tools}
