.patchLog2 <- function(...) {
  # Nothing to do?
  if (compareVersion(as.character(getRversion()), "2.7.0") >= 0)
    return();

  log2.patch <- function(x) {
    suppressWarnings({
      base::log2(x);
    })
  }

  log10.patch <- function(x) {
    suppressWarnings({
      base::log10(x);
    })
  }
  
  envir <- as.environment("package:aroma.core");
  assign("log2", log2.patch, envir=envir);
  assign("log10", log10.patch, envir=envir);
} # .patchLog2()


############################################################################
# HISTORY:
# 2008-03-29 [HB]
# o Created.  base::log2() in pre-R v2.7.0 will generate warnings that are
#   extremely slow to display. See R-devel thread 'Warnings generated by 
#   log2()/log10() are really large/takes a long time to display' on 
#   2008-02-26 for details. This has been fixed in R v2.7.0.
############################################################################
