% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/5_SimulateModels.R
\name{ClosedNetwork}
\alias{ClosedNetwork}
\title{Obtains the main characteristics of a Closed Network model by simulation}
\usage{
ClosedNetwork(serviceDistribution = c(Exp(5), Exp(5), Exp(10), Exp(15)),
  s = c(2, 2, 1, 1), p = array(c(0.25, 0.15, 0.5, 0.4, 0.15, 0.35, 0.25,
  0.3, 0.2, 0.2, 0.15, 0.25, 0.4, 0.3, 0.1, 0.05), dim = c(4, 4)),
  staClients = 100, nClients = 3, transitions = 1000, historic = FALSE,
  nsim = 10, nproc = 1)
}
\arguments{
\item{serviceDistribution}{Service distributions for the nodes of the network (Each element must be an object of S4-class \code{distr}
defined in \pkg{distr} package)}

\item{s}{Vector of servers at each node}

\item{p}{Routing matrix, where \ifelse{latex}{\eqn{p_{ij}}}{\out{<i>p<sub>ij</sub></i>}} is the routing probability from node i to node j}

\item{staClients}{Number of customers used in the stabilization stage}

\item{nClients}{Number of customers in the system}

\item{transitions}{Number of transitions between nodes used in the simulation stage}

\item{historic}{Parameter to activate/deactivate the historic information}

\item{nsim}{Number of simulations}

\item{nproc}{Processors used in the simulation.}
}
\value{
Returns the next information of a Closed Network model:
\item{pn}{Vector of empirical steady-state probabilities of having n customers in the system: \ifelse{latex}{\eqn{P_n}}{\out{<i>P<sub>n</sub></i>}} (Only the probabilities bigger than 0 are included)}
\item{l}{Vector of empirical number of customers in the nodes: \eqn{L}}
\item{lq}{Vector of empirical number of customers in the queues of the nodes: \ifelse{latex}{\eqn{L_{q}}}{\out{<i>L<sub>q</sub></i>}}}
\item{lqt}{Empirical number of customers in the all the queues: \ifelse{latex}{\eqn{L_{qTotal}}}{\out{<i>L_<sub>qTotal</sub></i>}}}
\item{w}{Vector of empirical waiting times in the nodes: \eqn{W}}
\item{wq}{Vector of empirical waiting times in the queues of the nodes: \ifelse{latex}{\eqn{W_{q}}}{\out{<i>W<sub>q</sub></i>}}}
\item{eff}{Empirical system efficiency: \ifelse{latex}{\eqn{Eff = W/(W-W_{q})}}{\out{<i>Eff = W/(W-W<sub>q</sub></i>)}}}
\item{rho}{Empirical traffic intensity: \eqn{\rho}}
\item{historic}{Optional parameter that stores the evolution of \ifelse{latex}{\eqn{L}, \eqn{L_q}, \eqn{W} and  \eqn{W_q}}{\out{L, L<sub>q</sub>, W, W<sub>q</sub>}}\emph{, Customers in the system, Rho and Elapsed time} during the simulation.}
}
\description{
Obtains the main characteristics of a Closed Network model by simulation
}
\examples{
ClosedNetwork(serviceDistribution = c(Exp(5), Exp(5), Exp(10), Exp(15)),
              s                   = c(2,2,1,1),
              p                   = matrix(c(0.25, 0.15, 0.2,  0.4,
                                             0.15, 0.35, 0.2,  0.3,
                                             0.5,  0.25, 0.15, 0.1,
                                             0.4,  0.3,  0.25, 0.05), 4, byrow=TRUE),
              nClient             = 3,
              staClients          = 10,
              transitions         = 100,
              nsim                = 10)
}
\seealso{
Other SimulatedModels: \code{\link{G_G_1_INF_H}};
  \code{\link{G_G_1_K}}; \code{\link{G_G_1}};
  \code{\link{G_G_INF}}; \code{\link{G_G_S_INF_H_Y}};
  \code{\link{G_G_S_INF_H}}; \code{\link{G_G_S_K}};
  \code{\link{G_G_S}}; \code{\link{OpenNetwork}}
}

