% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/partitions.R
\name{partitions}
\alias{partitions}
\title{Partitions generator}
\usage{
partitions(n, k = NULL, descending = FALSE, type = "r")
}
\arguments{
\item{n}{an non-negative integer to be partitioned}

\item{k}{number of parts}

\item{descending}{logical to use reversed lexicographical order}

\item{type}{if "r", "c" or "l" is specified, the returned value would be a
"row-major" matrix, a "column-major" matrix or a list respectively}
}
\description{
This function partitions an non-negative interger \code{n} into \code{k} parts or any part size.
The results are in lexicographical or reversed lexicographical order.
}
\examples{
# all partitions of 6
partitions(6)
# reversed lexicographical order
partitions(6, descending = TRUE)

# fixed number of parts
partitions(10, 5)
# reversed lexicographical order
partitions(10, 5, descending = TRUE)

# column major
partitions(6, type = "c")
partitions(6, 3, type = "c")

# list output
partitions(6, type = "l")
partitions(6, 3, type = "l")

# zero sized partitions
dim(partitions(0))
dim(partitions(5, 0))
dim(partitions(5, 6))
dim(partitions(0, 0))
dim(partitions(0, 1))

}
\seealso{
\link{ipartitions} for iterating partitions and \link{npartitions} to calculate number of partitions
}
