// Generated by rstantools.  Do not edit by hand.

/*
    artemis is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    artemis is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with artemis.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef MODELS_HPP
#define MODELS_HPP
#define STAN__SERVICES__COMMAND_HPP
#include <rstan/rstaninc.hpp>
// Code generated by Stan version 2.21.0
#include <stan/model/model_header.hpp>
namespace model_eDNA_lm_zinf_namespace {
using std::istream;
using std::string;
using std::stringstream;
using std::vector;
using stan::io::dump;
using stan::math::lgamma;
using stan::model::prob_grad;
using namespace stan::math;
static int current_statement_begin__;
stan::io::program_reader prog_reader__() {
    stan::io::program_reader reader;
    reader.add_event(0, 0, "start", "model_eDNA_lm_zinf");
    reader.add_event(74, 72, "end", "model_eDNA_lm_zinf");
    return reader;
}
#include <stan_meta_header.hpp>
class model_eDNA_lm_zinf
  : public stan::model::model_base_crtp<model_eDNA_lm_zinf> {
private:
        int N_obs;
        int N_cens;
        int K;
        matrix_d X_obs;
        matrix_d X_cens;
        vector_d y_obs;
        vector_d L;
        double prior_int_mu;
        double prior_int_sd;
        vector_d prior_mu;
        vector_d prior_sd;
        int has_inter;
public:
    model_eDNA_lm_zinf(stan::io::var_context& context__,
        std::ostream* pstream__ = 0)
        : model_base_crtp(0) {
        ctor_body(context__, 0, pstream__);
    }
    model_eDNA_lm_zinf(stan::io::var_context& context__,
        unsigned int random_seed__,
        std::ostream* pstream__ = 0)
        : model_base_crtp(0) {
        ctor_body(context__, random_seed__, pstream__);
    }
    void ctor_body(stan::io::var_context& context__,
                   unsigned int random_seed__,
                   std::ostream* pstream__) {
        typedef double local_scalar_t__;
        boost::ecuyer1988 base_rng__ =
          stan::services::util::create_rng(random_seed__, 0);
        (void) base_rng__;  // suppress unused var warning
        current_statement_begin__ = -1;
        static const char* function__ = "model_eDNA_lm_zinf_namespace::model_eDNA_lm_zinf";
        (void) function__;  // dummy to suppress unused var warning
        size_t pos__;
        (void) pos__;  // dummy to suppress unused var warning
        std::vector<int> vals_i__;
        std::vector<double> vals_r__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
        try {
            // initialize data block variables from context__
            current_statement_begin__ = 8;
            context__.validate_dims("data initialization", "N_obs", "int", context__.to_vec());
            N_obs = int(0);
            vals_i__ = context__.vals_i("N_obs");
            pos__ = 0;
            N_obs = vals_i__[pos__++];
            check_greater_or_equal(function__, "N_obs", N_obs, 0);
            current_statement_begin__ = 9;
            context__.validate_dims("data initialization", "N_cens", "int", context__.to_vec());
            N_cens = int(0);
            vals_i__ = context__.vals_i("N_cens");
            pos__ = 0;
            N_cens = vals_i__[pos__++];
            check_greater_or_equal(function__, "N_cens", N_cens, 0);
            current_statement_begin__ = 10;
            context__.validate_dims("data initialization", "K", "int", context__.to_vec());
            K = int(0);
            vals_i__ = context__.vals_i("K");
            pos__ = 0;
            K = vals_i__[pos__++];
            check_greater_or_equal(function__, "K", K, 0);
            current_statement_begin__ = 11;
            validate_non_negative_index("X_obs", "N_obs", N_obs);
            validate_non_negative_index("X_obs", "K", K);
            context__.validate_dims("data initialization", "X_obs", "matrix_d", context__.to_vec(N_obs,K));
            X_obs = Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic>(N_obs, K);
            vals_r__ = context__.vals_r("X_obs");
            pos__ = 0;
            size_t X_obs_j_2_max__ = K;
            size_t X_obs_j_1_max__ = N_obs;
            for (size_t j_2__ = 0; j_2__ < X_obs_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < X_obs_j_1_max__; ++j_1__) {
                    X_obs(j_1__, j_2__) = vals_r__[pos__++];
                }
            }
            current_statement_begin__ = 12;
            validate_non_negative_index("X_cens", "N_cens", N_cens);
            validate_non_negative_index("X_cens", "K", K);
            context__.validate_dims("data initialization", "X_cens", "matrix_d", context__.to_vec(N_cens,K));
            X_cens = Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic>(N_cens, K);
            vals_r__ = context__.vals_r("X_cens");
            pos__ = 0;
            size_t X_cens_j_2_max__ = K;
            size_t X_cens_j_1_max__ = N_cens;
            for (size_t j_2__ = 0; j_2__ < X_cens_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < X_cens_j_1_max__; ++j_1__) {
                    X_cens(j_1__, j_2__) = vals_r__[pos__++];
                }
            }
            current_statement_begin__ = 13;
            validate_non_negative_index("y_obs", "N_obs", N_obs);
            context__.validate_dims("data initialization", "y_obs", "vector_d", context__.to_vec(N_obs));
            y_obs = Eigen::Matrix<double, Eigen::Dynamic, 1>(N_obs);
            vals_r__ = context__.vals_r("y_obs");
            pos__ = 0;
            size_t y_obs_j_1_max__ = N_obs;
            for (size_t j_1__ = 0; j_1__ < y_obs_j_1_max__; ++j_1__) {
                y_obs(j_1__) = vals_r__[pos__++];
            }
            current_statement_begin__ = 14;
            validate_non_negative_index("L", "N_cens", N_cens);
            context__.validate_dims("data initialization", "L", "vector_d", context__.to_vec(N_cens));
            L = Eigen::Matrix<double, Eigen::Dynamic, 1>(N_cens);
            vals_r__ = context__.vals_r("L");
            pos__ = 0;
            size_t L_j_1_max__ = N_cens;
            for (size_t j_1__ = 0; j_1__ < L_j_1_max__; ++j_1__) {
                L(j_1__) = vals_r__[pos__++];
            }
            current_statement_begin__ = 17;
            context__.validate_dims("data initialization", "prior_int_mu", "double", context__.to_vec());
            prior_int_mu = double(0);
            vals_r__ = context__.vals_r("prior_int_mu");
            pos__ = 0;
            prior_int_mu = vals_r__[pos__++];
            current_statement_begin__ = 18;
            context__.validate_dims("data initialization", "prior_int_sd", "double", context__.to_vec());
            prior_int_sd = double(0);
            vals_r__ = context__.vals_r("prior_int_sd");
            pos__ = 0;
            prior_int_sd = vals_r__[pos__++];
            check_greater_or_equal(function__, "prior_int_sd", prior_int_sd, 0);
            current_statement_begin__ = 19;
            validate_non_negative_index("prior_mu", "K", K);
            context__.validate_dims("data initialization", "prior_mu", "vector_d", context__.to_vec(K));
            prior_mu = Eigen::Matrix<double, Eigen::Dynamic, 1>(K);
            vals_r__ = context__.vals_r("prior_mu");
            pos__ = 0;
            size_t prior_mu_j_1_max__ = K;
            for (size_t j_1__ = 0; j_1__ < prior_mu_j_1_max__; ++j_1__) {
                prior_mu(j_1__) = vals_r__[pos__++];
            }
            current_statement_begin__ = 20;
            validate_non_negative_index("prior_sd", "K", K);
            context__.validate_dims("data initialization", "prior_sd", "vector_d", context__.to_vec(K));
            prior_sd = Eigen::Matrix<double, Eigen::Dynamic, 1>(K);
            vals_r__ = context__.vals_r("prior_sd");
            pos__ = 0;
            size_t prior_sd_j_1_max__ = K;
            for (size_t j_1__ = 0; j_1__ < prior_sd_j_1_max__; ++j_1__) {
                prior_sd(j_1__) = vals_r__[pos__++];
            }
            check_greater_or_equal(function__, "prior_sd", prior_sd, 0);
            current_statement_begin__ = 23;
            context__.validate_dims("data initialization", "has_inter", "int", context__.to_vec());
            has_inter = int(0);
            vals_i__ = context__.vals_i("has_inter");
            pos__ = 0;
            has_inter = vals_i__[pos__++];
            check_greater_or_equal(function__, "has_inter", has_inter, 0);
            check_less_or_equal(function__, "has_inter", has_inter, 1);
            // initialize transformed data variables
            // execute transformed data statements
            // validate transformed data
            // validate, set parameter ranges
            num_params_r__ = 0U;
            param_ranges_i__.clear();
            current_statement_begin__ = 28;
            validate_non_negative_index("intercept", "(has_inter ? 1 : 0 )", (has_inter ? 1 : 0 ));
            num_params_r__ += (1 * (has_inter ? 1 : 0 ));
            current_statement_begin__ = 29;
            validate_non_negative_index("betas", "K", K);
            num_params_r__ += K;
            current_statement_begin__ = 30;
            num_params_r__ += 1;
            current_statement_begin__ = 31;
            num_params_r__ += 1;
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
    }
    ~model_eDNA_lm_zinf() { }
    void transform_inits(const stan::io::var_context& context__,
                         std::vector<int>& params_i__,
                         std::vector<double>& params_r__,
                         std::ostream* pstream__) const {
        typedef double local_scalar_t__;
        stan::io::writer<double> writer__(params_r__, params_i__);
        size_t pos__;
        (void) pos__; // dummy call to supress warning
        std::vector<double> vals_r__;
        std::vector<int> vals_i__;
        current_statement_begin__ = 28;
        if (!(context__.contains_r("intercept")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable intercept missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("intercept");
        pos__ = 0U;
        validate_non_negative_index("intercept", "(has_inter ? 1 : 0 )", (has_inter ? 1 : 0 ));
        context__.validate_dims("parameter initialization", "intercept", "double", context__.to_vec((has_inter ? 1 : 0 )));
        std::vector<double> intercept((has_inter ? 1 : 0 ), double(0));
        size_t intercept_k_0_max__ = (has_inter ? 1 : 0 );
        for (size_t k_0__ = 0; k_0__ < intercept_k_0_max__; ++k_0__) {
            intercept[k_0__] = vals_r__[pos__++];
        }
        size_t intercept_i_0_max__ = (has_inter ? 1 : 0 );
        for (size_t i_0__ = 0; i_0__ < intercept_i_0_max__; ++i_0__) {
            try {
                writer__.scalar_unconstrain(intercept[i_0__]);
            } catch (const std::exception& e) {
                stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable intercept: ") + e.what()), current_statement_begin__, prog_reader__());
            }
        }
        current_statement_begin__ = 29;
        if (!(context__.contains_r("betas")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable betas missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("betas");
        pos__ = 0U;
        validate_non_negative_index("betas", "K", K);
        context__.validate_dims("parameter initialization", "betas", "vector_d", context__.to_vec(K));
        Eigen::Matrix<double, Eigen::Dynamic, 1> betas(K);
        size_t betas_j_1_max__ = K;
        for (size_t j_1__ = 0; j_1__ < betas_j_1_max__; ++j_1__) {
            betas(j_1__) = vals_r__[pos__++];
        }
        try {
            writer__.vector_unconstrain(betas);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable betas: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 30;
        if (!(context__.contains_r("sigma_ln_eDNA")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable sigma_ln_eDNA missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("sigma_ln_eDNA");
        pos__ = 0U;
        context__.validate_dims("parameter initialization", "sigma_ln_eDNA", "double", context__.to_vec());
        double sigma_ln_eDNA(0);
        sigma_ln_eDNA = vals_r__[pos__++];
        try {
            writer__.scalar_lb_unconstrain(0, sigma_ln_eDNA);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable sigma_ln_eDNA: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 31;
        if (!(context__.contains_r("p_zero")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable p_zero missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("p_zero");
        pos__ = 0U;
        context__.validate_dims("parameter initialization", "p_zero", "double", context__.to_vec());
        double p_zero(0);
        p_zero = vals_r__[pos__++];
        try {
            writer__.scalar_lub_unconstrain(0, 1, p_zero);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable p_zero: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        params_r__ = writer__.data_r();
        params_i__ = writer__.data_i();
    }
    void transform_inits(const stan::io::var_context& context,
                         Eigen::Matrix<double, Eigen::Dynamic, 1>& params_r,
                         std::ostream* pstream__) const {
      std::vector<double> params_r_vec;
      std::vector<int> params_i_vec;
      transform_inits(context, params_i_vec, params_r_vec, pstream__);
      params_r.resize(params_r_vec.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r(i) = params_r_vec[i];
    }
    template <bool propto__, bool jacobian__, typename T__>
    T__ log_prob(std::vector<T__>& params_r__,
                 std::vector<int>& params_i__,
                 std::ostream* pstream__ = 0) const {
        typedef T__ local_scalar_t__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // dummy to suppress unused var warning
        T__ lp__(0.0);
        stan::math::accumulator<T__> lp_accum__;
        try {
            stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);
            // model parameters
            current_statement_begin__ = 28;
            std::vector<local_scalar_t__> intercept;
            size_t intercept_d_0_max__ = (has_inter ? 1 : 0 );
            intercept.reserve(intercept_d_0_max__);
            for (size_t d_0__ = 0; d_0__ < intercept_d_0_max__; ++d_0__) {
                if (jacobian__)
                    intercept.push_back(in__.scalar_constrain(lp__));
                else
                    intercept.push_back(in__.scalar_constrain());
            }
            current_statement_begin__ = 29;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> betas;
            (void) betas;  // dummy to suppress unused var warning
            if (jacobian__)
                betas = in__.vector_constrain(K, lp__);
            else
                betas = in__.vector_constrain(K);
            current_statement_begin__ = 30;
            local_scalar_t__ sigma_ln_eDNA;
            (void) sigma_ln_eDNA;  // dummy to suppress unused var warning
            if (jacobian__)
                sigma_ln_eDNA = in__.scalar_lb_constrain(0, lp__);
            else
                sigma_ln_eDNA = in__.scalar_lb_constrain(0);
            current_statement_begin__ = 31;
            local_scalar_t__ p_zero;
            (void) p_zero;  // dummy to suppress unused var warning
            if (jacobian__)
                p_zero = in__.scalar_lub_constrain(0, 1, lp__);
            else
                p_zero = in__.scalar_lub_constrain(0, 1);
            // model body
            {
            current_statement_begin__ = 36;
            validate_non_negative_index("mu_cens", "N_cens", N_cens);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> mu_cens(N_cens);
            stan::math::initialize(mu_cens, DUMMY_VAR__);
            stan::math::fill(mu_cens, DUMMY_VAR__);
            stan::math::assign(mu_cens,add(multiply(X_cens, betas), (has_inter ? stan::math::promote_scalar<local_scalar_t__>(get_base1(intercept, 1, "intercept", 1)) : stan::math::promote_scalar<local_scalar_t__>(0.0) )));
            current_statement_begin__ = 40;
            lp_accum__.add(normal_log<propto__>(intercept, prior_int_mu, prior_int_sd));
            current_statement_begin__ = 42;
            for (int k = 1; k <= K; ++k) {
                current_statement_begin__ = 43;
                lp_accum__.add(normal_log<propto__>(get_base1(betas, k, "betas", 1), get_base1(prior_mu, k, "prior_mu", 1), get_base1(prior_sd, k, "prior_sd", 1)));
            }
            current_statement_begin__ = 45;
            lp_accum__.add(normal_log<propto__>(sigma_ln_eDNA, 0, 1));
            current_statement_begin__ = 47;
            lp_accum__.add(normal_id_glm_lpdf<propto__>(y_obs, X_obs, (has_inter ? stan::math::promote_scalar<local_scalar_t__>(get_base1(intercept, 1, "intercept", 1)) : stan::math::promote_scalar<local_scalar_t__>(0.0) ), betas, sigma_ln_eDNA));
            current_statement_begin__ = 49;
            lp_accum__.add((N_obs * bernoulli_log(0, p_zero)));
            current_statement_begin__ = 50;
            for (int n = 1; n <= N_cens; ++n) {
                current_statement_begin__ = 51;
                lp_accum__.add(log_sum_exp(bernoulli_log(1, p_zero), (bernoulli_log(0, p_zero) + normal_cdf_log(get_base1(L, n, "L", 1), get_base1(mu_cens, n, "mu_cens", 1), sigma_ln_eDNA))));
            }
            }
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
        lp_accum__.add(lp__);
        return lp_accum__.sum();
    } // log_prob()
    template <bool propto, bool jacobian, typename T_>
    T_ log_prob(Eigen::Matrix<T_,Eigen::Dynamic,1>& params_r,
               std::ostream* pstream = 0) const {
      std::vector<T_> vec_params_r;
      vec_params_r.reserve(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        vec_params_r.push_back(params_r(i));
      std::vector<int> vec_params_i;
      return log_prob<propto,jacobian,T_>(vec_params_r, vec_params_i, pstream);
    }
    void get_param_names(std::vector<std::string>& names__) const {
        names__.resize(0);
        names__.push_back("intercept");
        names__.push_back("betas");
        names__.push_back("sigma_ln_eDNA");
        names__.push_back("p_zero");
        names__.push_back("log_lik");
    }
    void get_dims(std::vector<std::vector<size_t> >& dimss__) const {
        dimss__.resize(0);
        std::vector<size_t> dims__;
        dims__.resize(0);
        dims__.push_back((has_inter ? 1 : 0 ));
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(K);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back((N_obs + N_cens));
        dimss__.push_back(dims__);
    }
    template <typename RNG>
    void write_array(RNG& base_rng__,
                     std::vector<double>& params_r__,
                     std::vector<int>& params_i__,
                     std::vector<double>& vars__,
                     bool include_tparams__ = true,
                     bool include_gqs__ = true,
                     std::ostream* pstream__ = 0) const {
        typedef double local_scalar_t__;
        vars__.resize(0);
        stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);
        static const char* function__ = "model_eDNA_lm_zinf_namespace::write_array";
        (void) function__;  // dummy to suppress unused var warning
        // read-transform, write parameters
        std::vector<double> intercept;
        size_t intercept_d_0_max__ = (has_inter ? 1 : 0 );
        intercept.reserve(intercept_d_0_max__);
        for (size_t d_0__ = 0; d_0__ < intercept_d_0_max__; ++d_0__) {
            intercept.push_back(in__.scalar_constrain());
        }
        size_t intercept_k_0_max__ = (has_inter ? 1 : 0 );
        for (size_t k_0__ = 0; k_0__ < intercept_k_0_max__; ++k_0__) {
            vars__.push_back(intercept[k_0__]);
        }
        Eigen::Matrix<double, Eigen::Dynamic, 1> betas = in__.vector_constrain(K);
        size_t betas_j_1_max__ = K;
        for (size_t j_1__ = 0; j_1__ < betas_j_1_max__; ++j_1__) {
            vars__.push_back(betas(j_1__));
        }
        double sigma_ln_eDNA = in__.scalar_lb_constrain(0);
        vars__.push_back(sigma_ln_eDNA);
        double p_zero = in__.scalar_lub_constrain(0, 1);
        vars__.push_back(p_zero);
        double lp__ = 0.0;
        (void) lp__;  // dummy to suppress unused var warning
        stan::math::accumulator<double> lp_accum__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
        if (!include_tparams__ && !include_gqs__) return;
        try {
            if (!include_gqs__ && !include_tparams__) return;
            if (!include_gqs__) return;
            // declare and define generated quantities
            current_statement_begin__ = 57;
            validate_non_negative_index("log_lik", "(N_obs + N_cens)", (N_obs + N_cens));
            Eigen::Matrix<double, Eigen::Dynamic, 1> log_lik((N_obs + N_cens));
            stan::math::initialize(log_lik, DUMMY_VAR__);
            stan::math::fill(log_lik, DUMMY_VAR__);
            // generated quantities statements
            current_statement_begin__ = 59;
            for (int n = 1; n <= N_obs; ++n) {
                current_statement_begin__ = 60;
                stan::model::assign(log_lik, 
                            stan::model::cons_list(stan::model::index_uni(n), stan::model::nil_index_list()), 
                            normal_log(get_base1(y_obs, n, "y_obs", 1), ((has_inter ? stan::math::promote_scalar<local_scalar_t__>(get_base1(intercept, 1, "intercept", 1)) : stan::math::promote_scalar<local_scalar_t__>(0.0) ) + multiply(get_base1(X_obs, n, "X_obs", 1), betas)), sigma_ln_eDNA), 
                            "assigning variable log_lik");
            }
            current_statement_begin__ = 64;
            for (int n = 1; n <= N_cens; ++n) {
                current_statement_begin__ = 65;
                stan::model::assign(log_lik, 
                            stan::model::cons_list(stan::model::index_uni((n + N_obs)), stan::model::nil_index_list()), 
                            log_sum_exp(bernoulli_log(1, p_zero), (bernoulli_log(0, p_zero) + normal_cdf_log(get_base1(L, n, "L", 1), ((has_inter ? stan::math::promote_scalar<local_scalar_t__>(get_base1(intercept, 1, "intercept", 1)) : stan::math::promote_scalar<local_scalar_t__>(0) ) + multiply(get_base1(X_cens, n, "X_cens", 1), betas)), sigma_ln_eDNA))), 
                            "assigning variable log_lik");
            }
            // validate, write generated quantities
            current_statement_begin__ = 57;
            size_t log_lik_j_1_max__ = (N_obs + N_cens);
            for (size_t j_1__ = 0; j_1__ < log_lik_j_1_max__; ++j_1__) {
                vars__.push_back(log_lik(j_1__));
            }
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
    }
    template <typename RNG>
    void write_array(RNG& base_rng,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& vars,
                     bool include_tparams = true,
                     bool include_gqs = true,
                     std::ostream* pstream = 0) const {
      std::vector<double> params_r_vec(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r_vec[i] = params_r(i);
      std::vector<double> vars_vec;
      std::vector<int> params_i_vec;
      write_array(base_rng, params_r_vec, params_i_vec, vars_vec, include_tparams, include_gqs, pstream);
      vars.resize(vars_vec.size());
      for (int i = 0; i < vars.size(); ++i)
        vars(i) = vars_vec[i];
    }
    std::string model_name() const {
        return "model_eDNA_lm_zinf";
    }
    void constrained_param_names(std::vector<std::string>& param_names__,
                                 bool include_tparams__ = true,
                                 bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        size_t intercept_k_0_max__ = (has_inter ? 1 : 0 );
        for (size_t k_0__ = 0; k_0__ < intercept_k_0_max__; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "intercept" << '.' << k_0__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t betas_j_1_max__ = K;
        for (size_t j_1__ = 0; j_1__ < betas_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "betas" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "sigma_ln_eDNA";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "p_zero";
        param_names__.push_back(param_name_stream__.str());
        if (!include_gqs__ && !include_tparams__) return;
        if (include_tparams__) {
        }
        if (!include_gqs__) return;
        size_t log_lik_j_1_max__ = (N_obs + N_cens);
        for (size_t j_1__ = 0; j_1__ < log_lik_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "log_lik" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
    }
    void unconstrained_param_names(std::vector<std::string>& param_names__,
                                   bool include_tparams__ = true,
                                   bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        size_t intercept_k_0_max__ = (has_inter ? 1 : 0 );
        for (size_t k_0__ = 0; k_0__ < intercept_k_0_max__; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "intercept" << '.' << k_0__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t betas_j_1_max__ = K;
        for (size_t j_1__ = 0; j_1__ < betas_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "betas" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "sigma_ln_eDNA";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "p_zero";
        param_names__.push_back(param_name_stream__.str());
        if (!include_gqs__ && !include_tparams__) return;
        if (include_tparams__) {
        }
        if (!include_gqs__) return;
        size_t log_lik_j_1_max__ = (N_obs + N_cens);
        for (size_t j_1__ = 0; j_1__ < log_lik_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "log_lik" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
    }
}; // model
}  // namespace
typedef model_eDNA_lm_zinf_namespace::model_eDNA_lm_zinf stan_model;
#ifndef USING_R
stan::model::model_base& new_model(
        stan::io::var_context& data_context,
        unsigned int seed,
        std::ostream* msg_stream) {
  stan_model* m = new stan_model(data_context, seed, msg_stream);
  return *m;
}
#endif
#endif
