##*******************************************************
## Function ruleInduction
##
## This is a poor man's implementation which mines all rules and
## then filters the rules which do not stam from the itemsets


setMethod("ruleInduction",  signature(x = "itemsets"),
    function(x, transactions, confidence = 0.8, method = "once", 
        verbose = FALSE) {

        nItems <- dim(transactions)[2]
        if (nItems != dim(items(x))[2])
        stop("Dimensions of x and transactions do not match!")

        # only need to mine items which occur in x
        items.involved <-  itemFrequency(items(x)) > 0
        names(items.involved) <- NULL

        transactions.sub <- transactions[, items.involved] 

        # itemset sizes
        isetsSize <-  size(x)

        # find minimal support and mine all rules
        # note: minSupport is reduced by epsilon so we get the rules
        #	with support == min support in x
        minSupport <-  min(quality(x)$support) - 1/length(transactions)


        rules <- apriori(transactions.sub,  parameter = list(
                support = minSupport,
                confidence = confidence, 
                target = "rules", 
                minlen = min(isetsSize), 
                maxlen = max(isetsSize)),
            control = list(verbose = verbose))

        # find rules which were generated by the itemsets
        if (verbose) cat(paste("starting to filter", length(rules), "rules.\n"))
        take <- !is.na(match(items(rules), items(x)[, items.involved]))
        if (verbose) cat("filtering done.\n")

        rules <- rules[take]
        if (verbose) cat("left with", length(rules), "rules.\n")

        # expand items back to full space
        # -1 since indices in dgCMatix start with 0 
        items.index <- as.integer(which(items.involved) - 1)

        # fix dim
        rules@lhs@data@Dim[1] <- nItems
        rules@rhs@data@Dim[1] <- nItems

        # fix column indices
        # +1 since indices in dgCMatix start with 0
        rules@lhs@data@i <- items.index[(rules@lhs@data@i +1)]
        rules@rhs@data@i <- items.index[(rules@rhs@data@i +1)]

        # fix item labels
        rules@lhs@itemInfo <- itemInfo(transactions)
        rules@rhs@itemInfo <- itemInfo(transactions)

        # return found rules
        rules 
    })


